/*
 * Decompiled with CFR 0.152.
 */
package com.thankjava.toolkit.core.utils;

import com.thankjava.toolkit.bean.utils.TimeType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class TimeUtil {
    private static final Map<String, SimpleDateFormat> SIMPLE_DATE_FORMAT_MAP = new HashMap<String, SimpleDateFormat>();

    private TimeUtil() {
    }

    public static Date parseDate(TimeType timeType, String date) {
        return TimeUtil.parseDate(timeType.type, date);
    }

    public static Date parseDate(String timeTypeString, String date) {
        SimpleDateFormat sdf = TimeUtil.getDateFormat(timeTypeString);
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SimpleDateFormat getDateFormat(String timeTypeString) {
        SimpleDateFormat sdf;
        if (timeTypeString == null) {
            timeTypeString = TimeType.DEFAULT.type;
        }
        if ((sdf = SIMPLE_DATE_FORMAT_MAP.get(timeTypeString)) == null) {
            sdf = new SimpleDateFormat(timeTypeString);
            SIMPLE_DATE_FORMAT_MAP.put(timeTypeString, sdf);
        }
        return sdf;
    }

    public static String formatDate(TimeType timeType, Date date) {
        return TimeUtil.formatDate(timeType.type, date);
    }

    public static String formatDate(String timeTypeString, Date date) {
        return TimeUtil.getDateFormat(timeTypeString).format(date);
    }

    public static Date offsetDate(Date date, int calendarUnit, int dateOffset) {
        if (date == null) {
            return null;
        }
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(calendarUnit, dateOffset);
        return ca.getTime();
    }
}

