/*
 * Decompiled with CFR 0.152.
 */
package com.tobedevoured.command.spring;

import com.tobedevoured.command.CommandException;
import com.tobedevoured.command.DefaultDependencyResolver;
import com.tobedevoured.command.spring.SpringCommandDependency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringDependencyResolver
extends DefaultDependencyResolver {
    ApplicationContext springContext;
    Map<Class, String> beanLookUp = new HashMap<Class, String>();

    public void init(Map<String, List> commandsToRun) {
        HashSet<String> contexts = new HashSet<String>();
        for (String command : commandsToRun.keySet()) {
            SpringCommandDependency dep = (SpringCommandDependency)((Object)this.manager.getCommands().get(command));
            if (dep == null) continue;
            contexts.addAll(dep.getContexts());
            if (!StringUtils.isNotBlank((String)dep.getBeanName())) continue;
            this.beanLookUp.put(dep.getTarget(), dep.getBeanName());
        }
        this.loadSpringContext(contexts);
    }

    public void loadSpringContext(Set<String> contexts) {
        this.springContext = new ClassPathXmlApplicationContext(contexts.toArray(new String[contexts.size()]));
    }

    public <T> T getInstance(Class<T> clazz) throws CommandException {
        String beanName = this.beanLookUp.get(clazz);
        try {
            if (StringUtils.isNotBlank((String)beanName)) {
                return (T)this.springContext.getBean(beanName);
            }
            return (T)this.springContext.getBean(clazz);
        }
        catch (NoSuchBeanDefinitionException e) {
            return (T)super.getInstance(clazz);
        }
    }
}

