/*
 * Decompiled with CFR 0.152.
 */
package com.toomuchcoding.jsonassert;

import com.jayway.jsonpath.DocumentContext;
import com.toomuchcoding.jsonassert.JsonAssertion;
import com.toomuchcoding.jsonassert.JsonVerifiable;
import org.assertj.core.api.AbstractAssert;

public class JsonPathAssert
extends AbstractAssert<JsonPathAssert, JsonVerifiable> {
    public JsonPathAssert(DocumentContext actual) {
        super((Object)JsonAssertion.assertThatJson((DocumentContext)actual), JsonPathAssert.class);
    }

    public JsonPathAssert(JsonVerifiable actual) {
        super((Object)actual, JsonPathAssert.class);
    }

    public JsonPathAssert contains(Object value) {
        this.isNotNull();
        return new JsonPathAssert(((JsonVerifiable)this.actual).contains(value));
    }

    public JsonPathAssert field(Object value) {
        this.isNotNull();
        return new JsonPathAssert(((JsonVerifiable)this.actual).field(value));
    }

    public JsonPathAssert field(String ... value) {
        this.isNotNull();
        return new JsonPathAssert(((JsonVerifiable)this.actual).field(value));
    }

    public JsonPathAssert array(Object value) {
        this.isNotNull();
        return new JsonPathAssert(((JsonVerifiable)this.actual).array(value));
    }

    public JsonPathAssert arrayField() {
        this.isNotNull();
        return new JsonPathAssert(((JsonVerifiable)this.actual).arrayField());
    }

    public JsonPathAssert array() {
        this.isNotNull();
        return new JsonPathAssert(((JsonVerifiable)this.actual).array());
    }

    public JsonPathAssert isEqualTo(String value) {
        this.isNotNull();
        JsonVerifiable jsonVerifiable = null;
        try {
            jsonVerifiable = ((JsonVerifiable)this.actual).isEqualTo(value);
        }
        catch (IllegalStateException e) {
            this.failWithMessage("Expected JSON to match JSON Path <%s> but it didn't", new Object[]{((JsonVerifiable)this.actual).jsonPath()});
        }
        return new JsonPathAssert(jsonVerifiable);
    }

    public JsonPathAssert isEqualTo(Number value) {
        this.isNotNull();
        JsonVerifiable jsonVerifiable = null;
        try {
            jsonVerifiable = ((JsonVerifiable)this.actual).isEqualTo(value);
        }
        catch (IllegalStateException e) {
            this.failWithMessage("Expected JSON to match JSON Path <%s> but it didn't", new Object[]{((JsonVerifiable)this.actual).jsonPath()});
        }
        return new JsonPathAssert(jsonVerifiable);
    }

    public JsonPathAssert isInstanceOf(Class clazz) {
        this.isNotNull();
        JsonVerifiable jsonVerifiable = null;
        try {
            jsonVerifiable = ((JsonVerifiable)this.actual).isInstanceOf(clazz);
        }
        catch (IllegalStateException e) {
            this.failWithMessage(e.getMessage(), new Object[0]);
        }
        return new JsonPathAssert(jsonVerifiable);
    }

    public JsonPathAssert matches(String value) {
        this.isNotNull();
        JsonVerifiable jsonVerifiable = null;
        try {
            jsonVerifiable = ((JsonVerifiable)this.actual).matches(value);
        }
        catch (IllegalStateException e) {
            this.failWithMessage("Expected JSON to match JSON Path <%s> but it didn't", new Object[]{((JsonVerifiable)this.actual).jsonPath()});
        }
        return new JsonPathAssert(jsonVerifiable);
    }

    public JsonPathAssert isEqualTo(Boolean value) {
        this.isNotNull();
        JsonVerifiable jsonVerifiable = null;
        try {
            jsonVerifiable = ((JsonVerifiable)this.actual).isEqualTo(value);
        }
        catch (IllegalStateException e) {
            this.failWithMessage("Expected JSON to match JSON Path <%s> but it didn't", new Object[]{((JsonVerifiable)this.actual).jsonPath()});
        }
        return new JsonPathAssert(jsonVerifiable);
    }

    public JsonPathAssert value() {
        this.isNotNull();
        JsonVerifiable jsonVerifiable = null;
        try {
            jsonVerifiable = ((JsonVerifiable)this.actual).value();
        }
        catch (IllegalStateException e) {
            this.failWithMessage("Expected JSON to match JSON Path <%s> but it didn't", new Object[]{((JsonVerifiable)this.actual).jsonPath()});
        }
        return new JsonPathAssert(jsonVerifiable);
    }

    public void isNull() {
        this.isNotNull();
        try {
            ((JsonVerifiable)this.actual).isNull();
        }
        catch (IllegalStateException e) {
            this.failWithMessage("Expected JSON to match JSON Path <%s> but it didn't", new Object[]{((JsonVerifiable)this.actual).jsonPath()});
        }
    }

    public JsonPathAssert matchesJsonPath(String jsonPath) {
        this.isNotNull();
        try {
            ((JsonVerifiable)this.actual).matchesJsonPath(jsonPath);
        }
        catch (IllegalStateException e) {
            this.failWithMessage("Expected JSON to match JSON Path <%s> but it didn't", new Object[]{jsonPath});
        }
        return this;
    }

    public JsonPathAssert isEmpty() {
        this.isNotNull();
        try {
            ((JsonVerifiable)this.actual).isEmpty();
        }
        catch (IllegalStateException e) {
            this.failWithMessage("Expected JSON to with JSON Path <%s> to be empty", new Object[]{((JsonVerifiable)this.actual).jsonPath()});
        }
        return this;
    }
}

