/*
 * Decompiled with CFR 0.152.
 */
package com.tryadhawk.airtable;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tryadhawk.airtable.Query;
import com.tryadhawk.airtable.exception.AirtableMappingException;
import com.tryadhawk.airtable.internal.http.AirtableHttpClient;
import com.tryadhawk.airtable.internal.http.QueryRequestBuilder;
import com.tryadhawk.airtable.v0.Delete;
import com.tryadhawk.airtable.v0.Record;
import com.tryadhawk.airtable.v0.Records;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.util.Objects;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncTable<T> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncTable.class);
    private final String url;
    private final String apiKey;
    private final Class<T> type;
    private final AirtableHttpClient httpClient;
    private final ObjectMapper objectMapper;
    private final QueryRequestBuilder queryRequestBuilder = new QueryRequestBuilder();

    AsyncTable(String url, String apiKey, Class<T> type, AirtableHttpClient httpClient, ObjectMapper objectMapper) {
        this.apiKey = Objects.requireNonNull(apiKey, "apiKey cannot be null");
        this.type = Objects.requireNonNull(type, "type cannot be null");
        this.url = Objects.requireNonNull(url, "url cannot be null");
        this.httpClient = Objects.requireNonNull(httpClient);
        this.objectMapper = Objects.requireNonNull(objectMapper);
    }

    public Publisher<Record<T>> select() {
        return this.select(Query.builder().build());
    }

    public Publisher<Record<T>> select(Query query) {
        return this.executeQuery(query).flatMap(records -> Flowable.fromIterable(records.getRecords()));
    }

    public Publisher<Record<T>> find(String id) {
        Request request = this.buildBaseRequest("GET", this.getTableUrl() + "/" + id).build();
        return Single.just((Object)request).flatMap(this.httpClient::execute).map(response -> this.parseResponseBodyAsRecord((Response)response)).doOnError(e -> logger.warn("Failed to find id {}", (Object)id)).toFlowable();
    }

    public Publisher<Record<T>> create(T item) {
        return Single.just(Record.of(item)).map(this::bodyToJson).map(body -> ((RequestBuilder)((RequestBuilder)this.buildBaseRequest("POST", this.getTableUrl()).addHeader((CharSequence)"Content-Type", "application/json")).setBody(body)).build()).flatMap(this.httpClient::execute).map(response -> this.parseResponseBodyAsRecord((Response)response)).doOnError(e -> logger.warn("Failed to create item {}", item)).toFlowable();
    }

    public Publisher<Record<T>> update(String id, T item) {
        return Single.just(Record.of(item)).map(this::bodyToJson).map(body -> ((RequestBuilder)((RequestBuilder)this.buildBaseRequest("PATCH", this.getTableUrl() + "/" + id).addHeader((CharSequence)"Content-Type", "application/json")).setBody(body)).build()).flatMap(this.httpClient::execute).map(response -> this.parseResponseBodyAsRecord((Response)response)).doOnError(e -> logger.warn("Failed to update id {}", (Object)id)).toFlowable();
    }

    public Publisher<Boolean> delete(String id) {
        Request request = this.buildBaseRequest("DELETE", this.getTableUrl() + "/" + id).build();
        return this.httpClient.execute(request).map(response -> (Delete)this.parseResponseBody((Response)response, this.objectMapper.constructType(Delete.class))).map(delete -> delete.isDeleted()).doOnError(e -> logger.warn("Failed to delete id {}", (Object)id)).toFlowable();
    }

    private Flowable<Records<T>> executeQuery(Query query) {
        return Single.just((Object)query).map(q -> ((RequestBuilder)((RequestBuilder)this.queryRequestBuilder.buildRequestForQuery((Query)q, this.getTableUrl()).setHeader((CharSequence)"Accept", "application/json")).setHeader((CharSequence)"Authorization", this.getAuthenticationHeader())).build()).flatMap(this.httpClient::execute).map(response -> this.parseResponseBodyAsRecords((Response)response)).doOnError(e -> logger.warn("Failed to execute query {}", (Object)query)).flatMapPublisher(records -> this.handleResponsePagination((Records<T>)records, query));
    }

    private Flowable<Records<T>> handleResponsePagination(Records<T> response, Query query) {
        Flowable f = Flowable.just(response);
        String offset = response.getOffset();
        if (offset != null) {
            logger.debug("Concatenating with next result set at offset {}", (Object)offset);
            f = f.concatWith(this.executeQuery(query.toBuilder().offset(offset).build()));
        }
        return f;
    }

    private byte[] bodyToJson(Object body) {
        try {
            return this.objectMapper.writeValueAsBytes(body);
        }
        catch (JsonProcessingException e) {
            throw new AirtableMappingException("Failed to map data to JSON", e);
        }
    }

    private Records<T> parseResponseBodyAsRecords(Response response) {
        JavaType javaType = this.objectMapper.getTypeFactory().constructParametricType(Records.class, new Class[]{this.type});
        return (Records)this.parseResponseBody(response, javaType);
    }

    private Record<T> parseResponseBodyAsRecord(Response response) {
        JavaType javaType = this.objectMapper.getTypeFactory().constructParametricType(Record.class, new Class[]{this.type});
        return (Record)this.parseResponseBody(response, javaType);
    }

    private <X> X parseResponseBody(Response response, JavaType javaType) {
        try {
            return (X)this.objectMapper.readValue(response.getResponseBody(), javaType);
        }
        catch (JsonProcessingException e) {
            throw new AirtableMappingException("Failed to map data to JSON", e);
        }
    }

    private String getTableUrl() {
        return this.url;
    }

    private String getAuthenticationHeader() {
        return "Bearer " + this.apiKey;
    }

    private RequestBuilder buildBaseRequest(String method, String url) {
        return (RequestBuilder)((RequestBuilder)((RequestBuilder)new RequestBuilder(method).setUrl(url)).setHeader((CharSequence)"Accept", "application/json")).setHeader((CharSequence)"Authorization", this.getAuthenticationHeader());
    }
}

