/*
 * Decompiled with CFR 0.152.
 */
package com.tryadhawk.airtable;

import com.tryadhawk.airtable.Sort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;

public final class Query {
    private final List<String> fields;
    @Nullable
    private final Integer pageSize;
    @Nullable
    private final Integer maxRecords;
    @Nullable
    private final String view;
    private final List<Sort> sorts;
    @Nullable
    private final String filterByFormula;
    @Nullable
    private final String offset;

    @Generated
    Query(List<String> fields, @Nullable Integer pageSize, @Nullable Integer maxRecords, @Nullable String view, List<Sort> sorts, @Nullable String filterByFormula, @Nullable String offset) {
        this.fields = fields;
        this.pageSize = pageSize;
        this.maxRecords = maxRecords;
        this.view = view;
        this.sorts = sorts;
        this.filterByFormula = filterByFormula;
        this.offset = offset;
    }

    @Generated
    public static QueryBuilder builder() {
        return new QueryBuilder();
    }

    @Generated
    public QueryBuilder toBuilder() {
        QueryBuilder builder = new QueryBuilder().pageSize(this.pageSize).maxRecords(this.maxRecords).view(this.view).filterByFormula(this.filterByFormula).offset(this.offset);
        if (this.fields != null) {
            builder.fields(this.fields);
        }
        if (this.sorts != null) {
            builder.sorts(this.sorts);
        }
        return builder;
    }

    @Generated
    public List<String> getFields() {
        return this.fields;
    }

    @Nullable
    @Generated
    public Integer getPageSize() {
        return this.pageSize;
    }

    @Nullable
    @Generated
    public Integer getMaxRecords() {
        return this.maxRecords;
    }

    @Nullable
    @Generated
    public String getView() {
        return this.view;
    }

    @Generated
    public List<Sort> getSorts() {
        return this.sorts;
    }

    @Nullable
    @Generated
    public String getFilterByFormula() {
        return this.filterByFormula;
    }

    @Nullable
    @Generated
    public String getOffset() {
        return this.offset;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Query)) {
            return false;
        }
        Query other = (Query)o;
        List<String> this$fields = this.getFields();
        List<String> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        Integer this$maxRecords = this.getMaxRecords();
        Integer other$maxRecords = other.getMaxRecords();
        if (this$maxRecords == null ? other$maxRecords != null : !((Object)this$maxRecords).equals(other$maxRecords)) {
            return false;
        }
        String this$view = this.getView();
        String other$view = other.getView();
        if (this$view == null ? other$view != null : !this$view.equals(other$view)) {
            return false;
        }
        List<Sort> this$sorts = this.getSorts();
        List<Sort> other$sorts = other.getSorts();
        if (this$sorts == null ? other$sorts != null : !((Object)this$sorts).equals(other$sorts)) {
            return false;
        }
        String this$filterByFormula = this.getFilterByFormula();
        String other$filterByFormula = other.getFilterByFormula();
        if (this$filterByFormula == null ? other$filterByFormula != null : !this$filterByFormula.equals(other$filterByFormula)) {
            return false;
        }
        String this$offset = this.getOffset();
        String other$offset = other.getOffset();
        return !(this$offset == null ? other$offset != null : !this$offset.equals(other$offset));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        Integer $maxRecords = this.getMaxRecords();
        result = result * 59 + ($maxRecords == null ? 43 : ((Object)$maxRecords).hashCode());
        String $view = this.getView();
        result = result * 59 + ($view == null ? 43 : $view.hashCode());
        List<Sort> $sorts = this.getSorts();
        result = result * 59 + ($sorts == null ? 43 : ((Object)$sorts).hashCode());
        String $filterByFormula = this.getFilterByFormula();
        result = result * 59 + ($filterByFormula == null ? 43 : $filterByFormula.hashCode());
        String $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : $offset.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Query(fields=" + this.getFields() + ", pageSize=" + this.getPageSize() + ", maxRecords=" + this.getMaxRecords() + ", view=" + this.getView() + ", sorts=" + this.getSorts() + ", filterByFormula=" + this.getFilterByFormula() + ", offset=" + this.getOffset() + ")";
    }

    @Generated
    public static class QueryBuilder {
        @Generated
        private ArrayList<String> fields;
        @Generated
        private Integer pageSize;
        @Generated
        private Integer maxRecords;
        @Generated
        private String view;
        @Generated
        private ArrayList<Sort> sorts;
        @Generated
        private String filterByFormula;
        @Generated
        private String offset;

        @Generated
        QueryBuilder() {
        }

        @Generated
        public QueryBuilder field(String field) {
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.add(field);
            return this;
        }

        @Generated
        public QueryBuilder fields(Collection<? extends String> fields) {
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.addAll(fields);
            return this;
        }

        @Generated
        public QueryBuilder clearFields() {
            if (this.fields != null) {
                this.fields.clear();
            }
            return this;
        }

        @Generated
        public QueryBuilder pageSize(@Nullable Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Generated
        public QueryBuilder maxRecords(@Nullable Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        @Generated
        public QueryBuilder view(@Nullable String view) {
            this.view = view;
            return this;
        }

        @Generated
        public QueryBuilder sort(Sort sort) {
            if (this.sorts == null) {
                this.sorts = new ArrayList();
            }
            this.sorts.add(sort);
            return this;
        }

        @Generated
        public QueryBuilder sorts(Collection<? extends Sort> sorts) {
            if (this.sorts == null) {
                this.sorts = new ArrayList();
            }
            this.sorts.addAll(sorts);
            return this;
        }

        @Generated
        public QueryBuilder clearSorts() {
            if (this.sorts != null) {
                this.sorts.clear();
            }
            return this;
        }

        @Generated
        public QueryBuilder filterByFormula(@Nullable String filterByFormula) {
            this.filterByFormula = filterByFormula;
            return this;
        }

        @Generated
        public QueryBuilder offset(@Nullable String offset) {
            this.offset = offset;
            return this;
        }

        @Generated
        public Query build() {
            List<Sort> sorts;
            List<String> fields;
            switch (this.fields == null ? 0 : this.fields.size()) {
                case 0: {
                    fields = Collections.emptyList();
                    break;
                }
                case 1: {
                    fields = Collections.singletonList(this.fields.get(0));
                    break;
                }
                default: {
                    fields = Collections.unmodifiableList(new ArrayList<String>(this.fields));
                }
            }
            switch (this.sorts == null ? 0 : this.sorts.size()) {
                case 0: {
                    sorts = Collections.emptyList();
                    break;
                }
                case 1: {
                    sorts = Collections.singletonList(this.sorts.get(0));
                    break;
                }
                default: {
                    sorts = Collections.unmodifiableList(new ArrayList<Sort>(this.sorts));
                }
            }
            return new Query(fields, this.pageSize, this.maxRecords, this.view, sorts, this.filterByFormula, this.offset);
        }

        @Generated
        public String toString() {
            return "Query.QueryBuilder(fields=" + this.fields + ", pageSize=" + this.pageSize + ", maxRecords=" + this.maxRecords + ", view=" + this.view + ", sorts=" + this.sorts + ", filterByFormula=" + this.filterByFormula + ", offset=" + this.offset + ")";
        }
    }
}

