/*
 * Decompiled with CFR 0.152.
 */
package com.tryadhawk.airtable;

import com.tryadhawk.airtable.AsyncTable;
import com.tryadhawk.airtable.Query;
import com.tryadhawk.airtable.v0.Record;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.util.List;
import java.util.Objects;

public class SyncTable<T> {
    private final AsyncTable<T> asyncTable;

    public SyncTable(AsyncTable<T> asyncTable) {
        this.asyncTable = Objects.requireNonNull(asyncTable, "asyncTable cannot be null");
    }

    public List<Record<T>> select() {
        return (List)Flowable.fromPublisher(this.asyncTable.select()).toList().blockingGet();
    }

    public List<Record<T>> select(Query query) {
        return (List)Flowable.fromPublisher(this.asyncTable.select(query)).toList().blockingGet();
    }

    public Record<T> find(String id) {
        return (Record)Single.fromPublisher(this.asyncTable.find(id)).blockingGet();
    }

    public Record<T> create(T item) {
        return (Record)Single.fromPublisher(this.asyncTable.create(item)).blockingGet();
    }

    public Record<T> update(String id, T item) {
        return (Record)Single.fromPublisher(this.asyncTable.update(id, item)).blockingGet();
    }

    public boolean delete(String id) {
        return (Boolean)Single.fromPublisher(this.asyncTable.delete(id)).blockingGet();
    }
}

