/*
 * Decompiled with CFR 0.152.
 */
package com.tryadhawk.airtable.exception;

import com.tryadhawk.airtable.exception.AirtableException;
import com.tryadhawk.airtable.v0.Error;
import javax.annotation.Nullable;

public class AirtableServerException
extends AirtableException {
    private final int statusCode;
    private final String statusText;
    private final Error error;

    public AirtableServerException(int statusCode) {
        this(statusCode, null, null, null);
    }

    public AirtableServerException(int statusCode, String statusText, Error error) {
        this(statusCode, statusText, error, null);
    }

    public AirtableServerException(int statusCode, String statusText, Error error, Throwable cause) {
        super(AirtableServerException.buildExceptionMessage(statusCode, statusText, error), cause);
        this.statusCode = statusCode;
        this.statusText = statusText == null ? "" : statusText;
        this.error = error;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    @Nullable
    public Error getError() {
        return this.error;
    }

    private static String buildExceptionMessage(int statusCode, String statusText, Error error) {
        StringBuilder sb = new StringBuilder("Status code: ").append(statusCode);
        if (statusText != null) {
            sb.append(", status text: ").append(statusText);
        }
        if (error != null) {
            sb.append(", error: ").append(error);
        }
        return sb.toString();
    }
}

