/*
 * Decompiled with CFR 0.152.
 */
package com.tryadhawk.airtable.internal.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tryadhawk.airtable.exception.AirtableServerException;
import com.tryadhawk.airtable.internal.http.HttpResponseExceptionHandler;
import com.tryadhawk.airtable.internal.reactive.ReactiveUtils;
import com.tryadhawk.airtable.internal.reactive.RetryWithDelay;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import java.util.Objects;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;

public class AirtableHttpClient {
    private final AsyncHttpClient httpClient;
    private final HttpResponseExceptionHandler exceptionHandler;
    private final int waitMin;
    private final int waitMax;

    public AirtableHttpClient(AsyncHttpClient httpClient, ObjectMapper objectMapper) {
        this(httpClient, objectMapper, new HttpResponseExceptionHandler(objectMapper));
    }

    public AirtableHttpClient(AsyncHttpClient httpClient, ObjectMapper objectMapper, HttpResponseExceptionHandler exceptionHandler) {
        this(httpClient, objectMapper, exceptionHandler, 30, 36);
    }

    AirtableHttpClient(AsyncHttpClient httpClient, ObjectMapper objectMapper, HttpResponseExceptionHandler exceptionHandler, int waitMin, int waitMax) {
        if (waitMin < 1 || waitMax < 1) {
            throw new IllegalArgumentException("waitMin and waitMax must be greater than 0");
        }
        if (waitMin >= waitMax) {
            throw new IllegalArgumentException("waitMin must be less than or equal to waitMax");
        }
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient cannot be null");
        Objects.requireNonNull(objectMapper, "objectMapper cannot be null");
        this.exceptionHandler = Objects.requireNonNull(exceptionHandler, "exceptionHandler cannot be null");
        this.waitMin = waitMin;
        this.waitMax = waitMax;
    }

    public Single<Response> execute(Request request) {
        return ReactiveUtils.fromFuture(() -> this.httpClient.executeRequest(request)).onErrorResumeNext(e -> this.exceptionHandler.handleError((Throwable)e)).flatMap(this.exceptionHandler::checkResponse).retryWhen((Function)RetryWithDelay.builder().waitMin(this.waitMin).waitMax(this.waitMax).predicate(e -> e instanceof AirtableServerException && ((AirtableServerException)e).getStatusCode() == 429).build());
    }
}

