/*
 * Decompiled with CFR 0.152.
 */
package com.tryadhawk.airtable.internal.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tryadhawk.airtable.exception.AirtableServerException;
import com.tryadhawk.airtable.v0.Error;
import com.tryadhawk.airtable.v0.ErrorWrapper;
import io.reactivex.Single;
import java.util.Objects;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(HttpResponseExceptionHandler.class);
    private final ObjectMapper objectMapper;

    public HttpResponseExceptionHandler(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper cannot be null");
    }

    public Single<Response> handleError(Throwable t) {
        return Single.error((Throwable)new AirtableServerException(500, "Internal server error", null, t));
    }

    public Single<Response> checkResponse(Response response) {
        return this.isErrorResponse(response) ? Single.error((Throwable)this.buildException(response)) : Single.just((Object)response);
    }

    private boolean isErrorResponse(Response response) {
        return response.getStatusCode() != 200;
    }

    private AirtableServerException buildException(Response response) {
        int status = response.getStatusCode();
        String statusText = response.getStatusText();
        Error err = this.extractError(response);
        return new AirtableServerException(status, statusText, err);
    }

    private Error extractError(Response response) {
        Error err;
        String body = response.getResponseBody();
        try {
            ErrorWrapper wrapper = (ErrorWrapper)this.objectMapper.readValue(body, ErrorWrapper.class);
            err = wrapper.getError();
        }
        catch (Exception e) {
            logger.warn("Failed to parse response body to error, body: {}", (Object)body, (Object)e);
            err = new Error("UNDEFINED_ERROR", body);
        }
        return err;
    }
}

