/*
 * Decompiled with CFR 0.152.
 */
package com.tryadhawk.airtable.internal.http;

import com.tryadhawk.airtable.Query;
import com.tryadhawk.airtable.Sort;
import java.util.List;
import org.asynchttpclient.RequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRequestBuilder {
    private static final Logger logger = LoggerFactory.getLogger(QueryRequestBuilder.class);

    public RequestBuilder buildRequestForQuery(Query query, String tableUrl) {
        RequestBuilder request = (RequestBuilder)new RequestBuilder("GET").setUrl(tableUrl);
        if (query.getFields() != null) {
            for (String field : query.getFields()) {
                request.addQueryParam("fields[]", field);
            }
        }
        if (query.getMaxRecords() != null) {
            request.addQueryParam("maxRecords", query.getMaxRecords().toString());
        }
        if (query.getView() != null) {
            request.addQueryParam("view", query.getView());
        }
        if (query.getFilterByFormula() != null) {
            request.addQueryParam("filterByFormula", query.getFilterByFormula());
        }
        if (query.getPageSize() != null) {
            this.handlePageSize(query.getPageSize(), request);
        }
        if (query.getSorts() != null) {
            this.handleSorting(query.getSorts(), request);
        }
        if (query.getOffset() != null) {
            request.addQueryParam("offset", query.getOffset());
        }
        logger.debug("Built query request: {}", (Object)request);
        return request;
    }

    private void handleSorting(List<Sort> sorting, RequestBuilder request) {
        int i = 0;
        for (Sort sort : sorting) {
            request.addQueryParam("sort[" + i + "][field]", sort.getField());
            request.addQueryParam("sort[" + i + "][direction]", sort.getDirection().toString());
            ++i;
        }
    }

    private void handlePageSize(int pageSize, RequestBuilder request) {
        if (pageSize > 100) {
            logger.warn("Using max pageSize of 100 instead of {}", (Object)pageSize);
            pageSize = 100;
        }
        request.addQueryParam("pageSize", Integer.toString(pageSize));
    }
}

