/*
 * Decompiled with CFR 0.152.
 */
package com.tryadhawk.airtable.internal.reactive;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryWithDelay
implements Function<Flowable<Throwable>, Publisher<?>> {
    private static final Logger logger = LoggerFactory.getLogger(RetryWithDelay.class);
    private static final List<Predicate<Throwable>> DEFAULT_PREDICATES = Collections.singletonList(new ExceptionRetryPredicate(Exception.class));
    private final int waitMin;
    private final int waitMax;
    private final int maxTries;
    private final List<Predicate<Throwable>> retryPredicates;

    private RetryWithDelay(int maxTries, int waitMin, int waitMax, List<Predicate<Throwable>> retryPredicates) {
        if (waitMin >= waitMax) {
            throw new IllegalArgumentException("waitMin must be less than waitMax");
        }
        this.maxTries = maxTries;
        this.waitMin = waitMin;
        this.waitMax = waitMax;
        this.retryPredicates = new ArrayList<Predicate<Throwable>>((Collection)Objects.requireNonNull(retryPredicates));
    }

    public static Builder builder() {
        return new Builder();
    }

    public Publisher<?> apply(Flowable<Throwable> errors) {
        return errors.flatMap(error -> {
            boolean retryable = this.isRetryableException((Throwable)error);
            if (retryable) {
                logger.info("Retryable operation failed with exception: {}", error.getClass());
            }
            logger.debug("Operation exception", error);
            return retryable ? Flowable.just((Object)error) : Flowable.error((Throwable)error);
        }).zipWith((Publisher)Flowable.range((int)1, (int)this.maxTries), (t, i) -> new Retry((int)i, (Throwable)t)).flatMap(retry -> retry.retry < this.maxTries ? Flowable.timer((long)this.randomWait(), (TimeUnit)TimeUnit.SECONDS) : Flowable.error((Throwable)retry.throwable)).doOnError(e -> logger.debug("Not retrying after error"));
    }

    private long randomWait() {
        return ThreadLocalRandom.current().nextInt(this.waitMin, this.waitMax);
    }

    private boolean isRetryableException(Throwable e) {
        boolean retryable = false;
        for (Predicate<Throwable> retryPredicate : this.retryPredicates) {
            if (!retryPredicate.test(e)) continue;
            retryable = true;
            break;
        }
        return retryable;
    }

    private static class ExceptionRetryPredicate
    implements Predicate<Throwable> {
        private final Class<? extends Throwable> clazz;

        ExceptionRetryPredicate(Class<? extends Throwable> clazz) {
            this.clazz = Objects.requireNonNull(clazz);
        }

        @Override
        public boolean test(Throwable throwable) {
            return this.clazz.isAssignableFrom(throwable.getClass());
        }
    }

    private static class Retry {
        final int retry;
        final Throwable throwable;

        private Retry(int retry, Throwable throwable) {
            this.retry = retry;
            this.throwable = throwable;
        }
    }

    public static class Builder {
        private int waitMin = 30;
        private int waitMax = 36;
        private int maxRetries = 5;
        private List<Predicate<Throwable>> retryPredicates;

        public Builder retries(int retries) {
            if (retries < 0) {
                throw new IllegalArgumentException("Retries cannot be negative");
            }
            this.maxRetries = retries;
            return this;
        }

        public Builder waitMin(int waitMin) {
            if (waitMin < 1) {
                throw new IllegalArgumentException("waitMin cannot be less than 1");
            }
            this.waitMin = waitMin;
            return this;
        }

        public Builder waitMax(int waitMax) {
            if (waitMax < 1) {
                throw new IllegalArgumentException("waitMax cannot be less than 1");
            }
            this.waitMax = waitMax;
            return this;
        }

        public Builder exception(Class<? extends Exception> clazz) {
            return this.predicate(new ExceptionRetryPredicate(clazz));
        }

        public Builder predicate(Predicate<Throwable> predicate) {
            if (this.retryPredicates == null) {
                this.retryPredicates = new ArrayList<Predicate<Throwable>>();
            }
            this.retryPredicates.add(predicate);
            return this;
        }

        public RetryWithDelay build() {
            if (this.retryPredicates == null) {
                this.retryPredicates = DEFAULT_PREDICATES;
            }
            return new RetryWithDelay(this.maxRetries + 1, this.waitMin, this.waitMax, this.retryPredicates);
        }

        private Builder() {
        }
    }
}

