/*
 * Decompiled with CFR 0.152.
 */
package com.turtlequeue;

import com.turtlequeue.GrpcLoggingClientInterceptor;
import com.turtlequeue.sdk.api.proto.TurtleQueueAdminGrpc;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.ArrayList;
import java.util.List;

public class TqAdminClient {
    ManagedChannel channel = null;
    TurtleQueueAdminGrpc.TurtleQueueAdminStub asyncStub = null;

    public TqAdminClient(String host, int port, Boolean secure) {
        ManagedChannelBuilder channelBuilder = ManagedChannelBuilder.forAddress((String)host, (int)port);
        if (secure.booleanValue()) {
            channelBuilder.useTransportSecurity();
        } else {
            channelBuilder.usePlaintext();
        }
        this.channel = channelBuilder.build();
        this.asyncStub = TurtleQueueAdminGrpc.newStub((Channel)ClientInterceptors.intercept((Channel)this.channel, (List)new ArrayList<ClientInterceptor>(){
            {
                this.add(new GrpcLoggingClientInterceptor());
            }
        }));
    }

    public TurtleQueueAdminGrpc.TurtleQueueAdminStub checkAndGetStub(Boolean requestConnection) throws Exception {
        if (this.channel == null) {
            throw new Exception("Internal error: null channel when initializing TqClient");
        }
        ConnectivityState state = this.channel.getState(requestConnection.booleanValue());
        if (!requestConnection.booleanValue() && state != ConnectivityState.READY) {
            throw new Exception("Trying to use the methods before the connection has been initialized, state = " + state);
        }
        return this.asyncStub;
    }

    public ConnectivityState getState() {
        return this.channel.getState(false);
    }

    public ManagedChannel close() throws Exception {
        return this.channel.shutdown();
    }
}

