/*
 * Decompiled with CFR 0.152.
 */
package com.turtlequeue;

import com.turtlequeue.ClientImpl;
import com.turtlequeue.HashingScheme;
import com.turtlequeue.ProducerImpl;
import com.turtlequeue.ProducerParams;
import com.turtlequeue.Topic;
import com.turtlequeue.TopicBuilderImpl;
import com.turtlequeue.sdk.api.proto.TurtleQueueGrpc;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class ProducerBuilder {
    private static final Logger logger = Logger.getLogger(TurtleQueueGrpc.class.getName());
    ClientImpl c = null;
    TopicBuilderImpl topicBuilder = null;
    String producerName = null;
    Map<String, String> properties = null;
    TimeUnit batchingMaxPublishDelayUnit = null;
    Long batchingMaxPublishDelayValue = null;
    Integer maxPendingMessages = null;
    Integer batchingMaxMessages = null;
    Boolean enableBatching = null;
    HashingScheme hashingScheme = null;
    TimeUnit sendTimeoutUnit = null;
    Integer sendTimeoutValue = null;

    public ProducerBuilder(ClientImpl c) {
        this.c = c;
        this.topicBuilder = new TopicBuilderImpl();
    }

    public ProducerBuilder namespace(String namespace) {
        this.topicBuilder.namespace(namespace);
        return this;
    }

    public ProducerBuilder persistent(Boolean persistent) {
        this.topicBuilder.persistent(persistent);
        return this;
    }

    public ProducerBuilder producerName(String producerName) {
        this.producerName = producerName;
        return this;
    }

    public ProducerBuilder topic(String topic) {
        this.topicBuilder.topic(topic);
        return this;
    }

    public ProducerBuilder topic(Topic topic) {
        this.topicBuilder.topic(topic);
        return this;
    }

    public ProducerBuilder properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public ProducerBuilder property(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
        return this;
    }

    public ProducerBuilder maxPendingMessages(int maxPendingMessages) {
        this.maxPendingMessages = maxPendingMessages;
        return this;
    }

    public ProducerBuilder enableBatching(boolean enableBatching) {
        this.enableBatching = enableBatching;
        return this;
    }

    public ProducerBuilder hashingScheme(HashingScheme hashingScheme) {
        this.hashingScheme = hashingScheme;
        return this;
    }

    public ProducerBuilder sendTimeout(int sendTimeout, TimeUnit unit) {
        this.sendTimeoutUnit = unit;
        this.sendTimeoutValue = sendTimeout;
        return this;
    }

    public CompletableFuture<ProducerImpl> create() {
        ProducerParams conf = new ProducerParams(this.c.getNextProducerId(), this.topicBuilder.build(), this.producerName, this.enableBatching, this.batchingMaxMessages, this.batchingMaxPublishDelayUnit, this.batchingMaxPublishDelayValue, this.maxPendingMessages, this.properties, this.hashingScheme, this.sendTimeoutUnit, this.sendTimeoutValue);
        return new ProducerImpl(this.c, conf).createReturn();
    }
}

