/*
 * Decompiled with CFR 0.152.
 */
package com.turtlequeue;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;

public class StateMachine<T> {
    private AtomicReference<T> state = new AtomicReference();

    StateMachine() {
    }

    protected T getInternalState() {
        return this.state.get();
    }

    protected StateMachine<T> setState(T st) {
        this.state.set(st);
        return this;
    }

    protected T getAndUpdateState(UnaryOperator<T> updater) {
        return this.state.getAndUpdate(updater);
    }

    protected boolean compareAndSet(T prev, T next) {
        return this.state.compareAndSet(prev, next);
    }

    protected void checkStateIs(T st, String desc) {
        if (this.state.get() != st) {
            throw new IllegalStateException(desc);
        }
    }
}

