/*
 * Decompiled with CFR 0.152.
 */
package com.turtlequeue;

import com.cognitect.transit.ArrayReader;
import com.cognitect.transit.DefaultReadHandler;
import com.cognitect.transit.MapReader;
import com.cognitect.transit.ReadHandler;
import com.cognitect.transit.Reader;
import com.cognitect.transit.WriteHandler;
import com.cognitect.transit.Writer;
import com.turtlequeue.Client;
import com.turtlequeue.ClientImpl;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ClientBuilder {
    String host = "";
    Integer port = -1;
    Boolean secure = true;
    String apiKey = null;
    String userToken = null;
    Map<String, ReadHandler<?, ?>> customReadHandlers = null;
    Map<Class, WriteHandler<?, ?>> customWriteHandlers = null;
    DefaultReadHandler<?> customReadDefaultHandler = null;
    WriteHandler<?, ?> customDefaultWriteHandler = null;
    MapReader<?, Map<Object, Object>, Object, Object> mapBuilder = null;
    ArrayReader<?, List<Object>, Object> listBuilder = null;
    Function<InputStream, Reader> transitReader = null;
    Function<OutputStream, Writer> transitWriter = null;
    String dataFormat = "application/transit+json";

    public ClientBuilder setHost(String host) {
        this.host = host;
        return this;
    }

    public ClientBuilder setPort(Integer port) {
        this.port = port;
        return this;
    }

    public ClientBuilder setSecure(Boolean secure) {
        this.secure = secure;
        return this;
    }

    public ClientBuilder setUserToken(String userToken) {
        this.userToken = userToken;
        return this;
    }

    public ClientBuilder setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public ClientBuilder transitWriteHandlers(Map<Class, WriteHandler<?, ?>> customHandlers) {
        this.customWriteHandlers = customHandlers;
        return this;
    }

    public ClientBuilder transitReadHandlers(Map<String, ReadHandler<?, ?>> customHandlers) {
        this.customReadHandlers = customHandlers;
        return this;
    }

    public ClientBuilder transitReadDefaultHandler(DefaultReadHandler<?> customDefaultHandler) {
        this.customReadDefaultHandler = customDefaultHandler;
        return this;
    }

    public ClientBuilder transitWriteDefaultHandler(WriteHandler<?, ?> defaultWriteHandler) {
        this.customDefaultWriteHandler = defaultWriteHandler;
        return this;
    }

    public ClientBuilder transitMapBuilder(MapReader<?, Map<Object, Object>, Object, Object> mapBuilder) {
        this.mapBuilder = mapBuilder;
        return this;
    }

    public ClientBuilder transitListBuilder(ArrayReader<?, List<Object>, Object> listBuilder) {
        this.listBuilder = listBuilder;
        return this;
    }

    public ClientBuilder transitReader(Function<InputStream, Reader> reader) {
        this.transitReader = reader;
        return this;
    }

    public ClientBuilder transitWriter(Function<OutputStream, Writer> writer) {
        this.transitWriter = writer;
        return this;
    }

    public ClientBuilder removeDefaultWriter() {
        this.transitWriter = null;
        return this;
    }

    public ClientBuilder removeDefaultReader() {
        this.transitReader = null;
        return this;
    }

    public ClientBuilder dataFormat(String dataFormat) {
        this.dataFormat = dataFormat;
        return this;
    }

    public Client build() {
        return new ClientImpl(this.host, this.port, this.secure, this.userToken, this.apiKey, this.transitReader, this.transitWriter, this.customReadHandlers, this.customWriteHandlers, this.customReadDefaultHandler, this.customDefaultWriteHandler, this.mapBuilder, this.listBuilder, this.dataFormat);
    }
}

