/*
 * Decompiled with CFR 0.152.
 */
package com.turtlequeue;

import com.turtlequeue.AuthenticationCallCredentials;
import com.turtlequeue.ClientImpl;
import com.turtlequeue.GrpcLoggingClientInterceptor;
import com.turtlequeue.sdk.api.proto.TurtleQueueGrpc;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ConnectivityState;
import io.grpc.Context;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TqClient {
    private static final Logger logger = Logger.getLogger(TurtleQueueGrpc.class.getName());
    ManagedChannel channel = null;
    TurtleQueueGrpc.TurtleQueueStub asyncStub = null;
    Context.CancellableContext withCancellation = null;
    ClientImpl c = null;

    public TqClient(ClientImpl c) {
        this.c = c;
        ManagedChannelBuilder channelBuilder = ManagedChannelBuilder.forAddress((String)c.getHost(), (int)c.getPort());
        if (c.getSecure().booleanValue()) {
            channelBuilder.useTransportSecurity();
        } else {
            channelBuilder.usePlaintext();
        }
        HashMap<String, Object> retryPolicy = new HashMap<String, Object>();
        retryPolicy.put("maxAttempts", 999.0);
        retryPolicy.put("initialBackoff", "10s");
        retryPolicy.put("maxBackoff", "5s");
        retryPolicy.put("backoffMultiplier", 1.0);
        retryPolicy.put("retryableStatusCodes", Arrays.asList("UNAVAILABLE"));
        HashMap<String, Object> methodConfigTq = new HashMap<String, Object>();
        HashMap<String, String> name = new HashMap<String, String>();
        name.put("service", "tq.TurtleQueue");
        methodConfigTq.put("name", Collections.singletonList(name));
        methodConfigTq.put("retryPolicy", retryPolicy);
        methodConfigTq.put("waitForReady", false);
        HashMap<String, Object> methodConfigTqAdm = new HashMap<String, Object>();
        HashMap<String, String> nameAdm = new HashMap<String, String>();
        nameAdm.put("service", "tqadmin.TurtleQueueAdmin");
        methodConfigTqAdm.put("name", Collections.singletonList(nameAdm));
        methodConfigTqAdm.put("retryPolicy", retryPolicy);
        methodConfigTqAdm.put("waitForReady", false);
        HashMap<String, List<Map>> serviceConfig = new HashMap<String, List<Map>>();
        serviceConfig.put("methodConfig", Arrays.asList(methodConfigTq, methodConfigTqAdm));
        channelBuilder.disableServiceConfigLookUp().enableRetry().defaultServiceConfig(serviceConfig).maxRetryAttempts(999);
        this.channel = channelBuilder.build();
        final TqClient thisRef = this;
        this.withCancellation = Context.current().withCancellation();
        this.withCancellation.run(new Runnable(){

            @Override
            public void run() {
                thisRef.asyncStub = (TurtleQueueGrpc.TurtleQueueStub)TurtleQueueGrpc.newStub((Channel)ClientInterceptors.intercept((Channel)TqClient.this.channel, (ClientInterceptor[])new ClientInterceptor[]{new GrpcLoggingClientInterceptor()})).withCallCredentials((CallCredentials)new AuthenticationCallCredentials(thisRef.c.getUserToken(), thisRef.c.getApiKey(), thisRef.c.getAuthMethod(), thisRef.c.getDataFormat(), thisRef.c.getSdkVersion()));
            }
        });
    }

    protected TurtleQueueGrpc.TurtleQueueStub checkAndGetStub(Boolean requestConnection) throws Exception {
        if (this.channel == null) {
            throw new Exception("Internal error: null channel when initializing TqClient");
        }
        ConnectivityState state = this.channel.getState(requestConnection.booleanValue());
        logger.log(Level.FINE, "Initializing TqClient requestConnection={0}, ConnectivityState={1} ", new Object[]{requestConnection, state});
        if (!requestConnection.booleanValue() && state != ConnectivityState.READY) {
            throw new Exception("Trying to use the methods before the connection has been initialized, state = " + state);
        }
        return this.asyncStub;
    }

    protected ConnectivityState getState() {
        return this.channel.getState(false);
    }

    protected ConnectivityState reconnectChannel() {
        logger.log(Level.FINE, "Reconnecting channel " + this.c.getHost() + ":" + this.c.getPort());
        ConnectivityState st = this.channel.getState(true);
        this.channel.resetConnectBackoff();
        return st;
    }

    protected synchronized void close() throws Exception {
        if (this.channel.isShutdown()) {
            logger.log(Level.WARNING, "Trying to close a client already closed");
            return;
        }
        try {
            logger.log(Level.FINE, "Closing Client Down");
            this.withCancellation.cancel((Throwable)new Exception("Client is closing"));
            this.channel.shutdown();
            if (!this.channel.awaitTermination(2500L, TimeUnit.MILLISECONDS)) {
                logger.log(Level.INFO, "Timed out trying to gracefully shut down the connection: {0}. ", this.channel);
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Unexpected exception while waiting for channel termination", ex);
        }
        if (!this.channel.isShutdown() || !this.channel.isTerminated()) {
            try {
                logger.log(Level.FINE, "Shutting down Client now");
                this.channel.shutdownNow();
                if (!this.channel.awaitTermination(2500L, TimeUnit.MILLISECONDS)) {
                    logger.log(Level.FINE, "Timed out forcefully shutting down connection: {0}. ", this.channel);
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Unexpected Exception while waiting for channel termination\n {0}", ex);
            }
        }
        if (this.channel.isTerminated()) {
            logger.log(Level.FINE, "Client has shut down");
        } else {
            logger.log(Level.WARNING, "Giving up closing the client");
        }
    }

    protected Channel getChannel() {
        return this.channel;
    }
}

