/*
 * Decompiled with CFR 0.152.
 */
package com.turtlequeue;

import com.turtlequeue.ClientImpl;
import com.turtlequeue.ConsumerBuilder;
import com.turtlequeue.MessageId;
import com.turtlequeue.Reader;
import com.turtlequeue.ReaderImpl;
import com.turtlequeue.SubscriptionMode;
import com.turtlequeue.Topic;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;

public class ReaderBuilder {
    ClientImpl c = null;
    ConsumerBuilder confBuilder = null;

    public ReaderBuilder(ClientImpl c) {
        this.c = c;
        this.confBuilder = new ConsumerBuilder(c);
    }

    public ReaderBuilder namespace(String namespace) {
        this.confBuilder.namespace(namespace);
        return this;
    }

    public ReaderBuilder topic(Topic topic) {
        this.confBuilder.topic(topic);
        return this;
    }

    public ReaderBuilder readerName(String readerName) {
        this.confBuilder.subscriptionName(readerName);
        return this;
    }

    public ReaderBuilder consumerName(String readerName) {
        this.confBuilder.consumerName(readerName);
        return this;
    }

    public ReaderBuilder initialPosition(MessageId messageId) {
        this.confBuilder.initialPosition(messageId);
        return this;
    }

    public ReaderBuilder ackTimeout(long ackTimeout, TimeUnit timeUnit) {
        this.confBuilder.ackTimeout(ackTimeout, timeUnit);
        return this;
    }

    public ReaderBuilder jsonPath(String jsonPath) {
        this.confBuilder.jsonPath(jsonPath);
        return this;
    }

    public CompletableFuture<Reader> create() {
        if (this.confBuilder.subName == null) {
            String subscription = "reader-" + DigestUtils.sha1Hex((String)UUID.randomUUID().toString()).substring(0, 10);
            this.confBuilder.subscriptionName(subscription);
        }
        this.confBuilder.subscriptionMode(SubscriptionMode.NonDurable);
        return new ReaderImpl(this.c, this.confBuilder.create()).subscribeReturn();
    }
}

