/*
 * Decompiled with CFR 0.152.
 */
package com.turtlequeue;

import com.turtlequeue.sdk.api.proto.TurtleQueueGrpc;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.MethodDescriptor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GrpcLoggingClientInterceptor
implements ClientInterceptor {
    private static final Logger logger = Logger.getLogger(TurtleQueueGrpc.class.getName());
    private String prefix = null;

    public GrpcLoggingClientInterceptor() {
        this.prefix = "";
    }

    public GrpcLoggingClientInterceptor(String p) {
        this.prefix = p;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        final String s = this.prefix + "Client says: {0} ";
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void sendMessage(ReqT message) {
                logger.log(Level.FINE, s, message);
                super.sendMessage(message);
            }
        };
    }
}

