/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.config;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfoxserver.client.config.EzyReconnectConfig;

public class EzyClientConfig {
    private final String zoneName;
    private final String clientName;
    private final EzyReconnectConfig reconnect;

    protected EzyClientConfig(Builder builder) {
        this.zoneName = builder.zoneName;
        this.clientName = builder.clientName;
        this.reconnect = builder.reconnectConfigBuilder.build();
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public String getClientName() {
        if (this.clientName == null) {
            return this.zoneName;
        }
        return this.clientName;
    }

    public EzyReconnectConfig getReconnect() {
        return this.reconnect;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements EzyBuilder<EzyClientConfig> {
        private String zoneName;
        private String clientName;
        private final EzyReconnectConfig.Builder reconnectConfigBuilder = new EzyReconnectConfig.Builder(this);

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public EzyReconnectConfig.Builder reconnectConfigBuilder() {
            return this.reconnectConfigBuilder;
        }

        public EzyClientConfig build() {
            return new EzyClientConfig(this);
        }
    }
}

