/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.socket;

import com.tvd12.ezyfox.callback.EzyCallback;
import com.tvd12.ezyfox.codec.EzyMessage;
import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfoxserver.client.concurrent.EzySynchronizedQueue;
import com.tvd12.ezyfoxserver.client.socket.EzySocketAdapter;
import com.tvd12.ezyfoxserver.client.socket.EzySocketDataDecoder;
import com.tvd12.ezyfoxserver.client.util.EzyQueue;
import java.nio.ByteBuffer;
import java.util.List;

public abstract class EzySocketReader
extends EzySocketAdapter {
    protected ByteBuffer buffer;
    protected EzyQueue<EzyArray> dataQueue;
    protected EzySocketDataDecoder decoder;
    protected final int readBufferSize;
    protected final EzyCallback<EzyMessage> decodeBytesCallback = new EzyCallback<EzyMessage>(){

        public void call(EzyMessage message) {
            EzySocketReader.this.onMesssageReceived(message);
        }
    };

    public EzySocketReader() {
        this.readBufferSize = 8192;
    }

    @Override
    protected void loop() {
        this.dataQueue = new EzySynchronizedQueue<EzyArray>();
        this.buffer = ByteBuffer.allocateDirect(this.readBufferSize);
        super.loop();
    }

    @Override
    protected void update() {
        while (true) {
            try {
                while (true) {
                    if (!this.active) {
                        return;
                    }
                    this.buffer.clear();
                    int bytesToRead = this.readSocketData();
                    if (bytesToRead <= 0) {
                        return;
                    }
                    this.buffer.flip();
                    byte[] binary = new byte[this.buffer.limit()];
                    this.buffer.get(binary);
                    this.decoder.decode(binary, this.decodeBytesCallback);
                }
            }
            catch (InterruptedException e) {
                this.logger.warn("socket reader interrupted", (Throwable)e);
                return;
            }
            catch (Exception e) {
                this.logger.warn("I/O error at socket-reader", (Throwable)e);
                continue;
            }
            break;
        }
    }

    protected abstract int readSocketData();

    @Override
    protected void clear() {
        if (this.dataQueue != null) {
            this.dataQueue.clear();
        }
    }

    public void popMessages(List<EzyArray> buffer) {
        this.dataQueue.pollAll(buffer);
    }

    private void onMesssageReceived(EzyMessage message) {
        try {
            Object data = this.decoder.decode(message);
            this.dataQueue.add((EzyArray)data);
        }
        catch (Exception e) {
            this.logger.warn("decode error at socket-reader", (Throwable)e);
        }
    }

    public void setDecoder(EzySocketDataDecoder decoder) {
        this.decoder = decoder;
    }

    @Override
    protected String getThreadName() {
        return "ezyfox-socket-reader";
    }
}

