/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.manager;

import com.tvd12.ezyfoxserver.client.entity.EzyPlugin;
import com.tvd12.ezyfoxserver.client.manager.EzyPluginManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EzySimplePluginManager
implements EzyPluginManager {
    protected final String zoneName;
    protected final List<EzyPlugin> pluginList;
    protected final Map<Integer, EzyPlugin> pluginsById;
    protected final Map<String, EzyPlugin> pluginsByName;

    public EzySimplePluginManager(String zoneName) {
        this.zoneName = zoneName;
        this.pluginList = new ArrayList<EzyPlugin>();
        this.pluginsById = new HashMap<Integer, EzyPlugin>();
        this.pluginsByName = new HashMap<String, EzyPlugin>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPlugin(EzyPlugin plugin) {
        EzySimplePluginManager ezySimplePluginManager = this;
        synchronized (ezySimplePluginManager) {
            this.pluginList.add(plugin);
            this.pluginsById.put(plugin.getId(), plugin);
            this.pluginsByName.put(plugin.getName(), plugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EzyPlugin removePlugin(int pluginId) {
        EzySimplePluginManager ezySimplePluginManager = this;
        synchronized (ezySimplePluginManager) {
            EzyPlugin plugin = this.pluginsById.remove(pluginId);
            if (plugin != null) {
                this.pluginList.remove(plugin);
                this.pluginsByName.remove(plugin.getName());
            }
            return plugin;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EzyPlugin getPlugin() {
        EzySimplePluginManager ezySimplePluginManager = this;
        synchronized (ezySimplePluginManager) {
            if (this.pluginList.isEmpty()) {
                throw new IllegalStateException("has no plugin in zone: " + this.zoneName);
            }
            return this.pluginList.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EzyPlugin> getPluginList() {
        ArrayList<EzyPlugin> list = new ArrayList<EzyPlugin>();
        EzySimplePluginManager ezySimplePluginManager = this;
        synchronized (ezySimplePluginManager) {
            list.addAll(this.pluginList);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EzyPlugin getPluginById(int pluginId) {
        List<EzyPlugin> list = this.pluginList;
        synchronized (list) {
            EzyPlugin plugin = this.pluginsById.get(pluginId);
            return plugin;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EzyPlugin getPluginByName(String pluginName) {
        EzySimplePluginManager ezySimplePluginManager = this;
        synchronized (ezySimplePluginManager) {
            EzyPlugin plugin = this.pluginsByName.get(pluginName);
            return plugin;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        EzySimplePluginManager ezySimplePluginManager = this;
        synchronized (ezySimplePluginManager) {
            this.pluginList.clear();
            this.pluginsById.clear();
            this.pluginsByName.clear();
        }
    }
}

