/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.socket;

import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.client.codec.EzyCodecFactory;
import com.tvd12.ezyfoxserver.client.constant.EzyConnectionType;
import com.tvd12.ezyfoxserver.client.constant.EzySocketStatus;
import com.tvd12.ezyfoxserver.client.constant.EzySocketStatuses;
import com.tvd12.ezyfoxserver.client.constant.EzyTransportType;
import com.tvd12.ezyfoxserver.client.socket.EzyBlockingPacketQueue;
import com.tvd12.ezyfoxserver.client.socket.EzyISocketClient;
import com.tvd12.ezyfoxserver.client.socket.EzyPacketQueue;
import com.tvd12.ezyfoxserver.client.socket.EzyResponseApi;
import com.tvd12.ezyfoxserver.client.socket.EzySimplePackage;
import com.tvd12.ezyfoxserver.client.socket.EzySimpleSocketDataDecoder;
import com.tvd12.ezyfoxserver.client.socket.EzySimpleSocketDataEncoder;
import com.tvd12.ezyfoxserver.client.socket.EzySocketAdapter;
import com.tvd12.ezyfoxserver.client.socket.EzySocketResponseApi;
import com.tvd12.ezyfoxserver.client.socket.EzyUdpSocketReader;
import com.tvd12.ezyfoxserver.client.socket.EzyUdpSocketWriter;
import com.tvd12.ezyfoxserver.client.util.EzyValueStack;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.List;

public class EzyUdpSocketClient
extends EzyLoggable
implements EzyISocketClient {
    protected long sessionId;
    protected String sessionToken;
    protected InetSocketAddress serverAddress;
    protected DatagramChannel datagramChannel;
    protected EzyUdpSocketReader socketReader;
    protected EzyUdpSocketWriter socketWriter;
    protected final EzyPacketQueue packetQueue;
    protected final EzyResponseApi responseApi;
    protected final EzyCodecFactory codecFactory;
    protected final EzyValueStack<EzySocketStatus> socketStatuses;

    public EzyUdpSocketClient(EzyCodecFactory codecFactory) {
        this.codecFactory = codecFactory;
        this.packetQueue = new EzyBlockingPacketQueue();
        this.responseApi = this.newResponseApi();
        this.socketStatuses = new EzyValueStack<EzySocketStatus>(EzySocketStatus.NOT_CONNECT);
    }

    private EzyResponseApi newResponseApi() {
        Object encoder = this.codecFactory.newEncoder(EzyConnectionType.SOCKET);
        EzySimpleSocketDataEncoder socketDataEncoder = new EzySimpleSocketDataEncoder(encoder);
        EzySocketResponseApi api = new EzySocketResponseApi(socketDataEncoder, this.packetQueue);
        return api;
    }

    @Override
    public void connectTo(String host, int port) {
        EzySocketStatus status = this.socketStatuses.last();
        if (!EzySocketStatuses.isSocketConnectable(status)) {
            this.logger.warn("udp socket is connecting...");
            return;
        }
        this.serverAddress = new InetSocketAddress(host, port);
        this.connect0();
    }

    @Override
    public boolean reconnect() {
        EzySocketStatus status = this.socketStatuses.last();
        if (status != EzySocketStatus.CONNECT_FAILED) {
            return false;
        }
        this.logger.info("udp socket is re-connecting...");
        this.connect0();
        return true;
    }

    public void setStatus(EzySocketStatus status) {
        this.socketStatuses.push(status);
    }

    protected void connect0() {
        try {
            this.clearAdapters();
            this.createAdapters();
            this.updateAdapters();
            this.closeSocket();
            this.packetQueue.clear();
            this.socketStatuses.clear();
            this.datagramChannel = DatagramChannel.open();
            this.datagramChannel.bind(null);
            this.datagramChannel.connect(this.serverAddress);
            this.startAdapters();
            this.socketStatuses.push(EzySocketStatus.CONNECTING);
            this.sendHandshakeRequest();
            Thread newThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(3000L);
                        EzySocketStatus status = EzyUdpSocketClient.this.socketStatuses.last();
                        if (status == EzySocketStatus.CONNECTING) {
                            EzyUdpSocketClient.this.socketStatuses.push(EzySocketStatus.CONNECT_FAILED);
                        }
                        EzyUdpSocketClient.this.reconnect();
                    }
                    catch (InterruptedException e) {
                        EzyUdpSocketClient.this.logger.error("udp reconnect interrupted", (Throwable)e);
                    }
                }
            });
            newThread.setName("udp-reconnect");
            newThread.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("udp can't connect to: " + this.serverAddress, e);
        }
    }

    @Override
    public void disconnect(int reason) {
        this.packetQueue.clear();
        this.packetQueue.wakeup();
        this.closeSocket();
        this.clearAdapters();
        this.socketStatuses.push(EzySocketStatus.DISCONNECTED);
    }

    @Override
    public void sendMessage(EzyArray message) {
        EzySimplePackage pack = new EzySimplePackage(message, EzyTransportType.UDP);
        try {
            this.responseApi.response(pack);
        }
        catch (Exception e) {
            this.logger.warn("udp send message: " + message + " error", (Throwable)e);
        }
    }

    public void popReadMessages(List<EzyArray> buffer) {
        EzySocketStatus status = this.socketStatuses.last();
        if (status == EzySocketStatus.CONNECTING || status == EzySocketStatus.CONNECTED) {
            this.socketReader.popMessages(buffer);
        }
    }

    protected void createAdapters() {
        this.socketReader = new EzyUdpSocketReader();
        this.socketWriter = new EzyUdpSocketWriter();
    }

    protected void updateAdapters() {
        Object decoder = this.codecFactory.newDecoder(EzyConnectionType.SOCKET);
        EzySimpleSocketDataDecoder socketDataDecoder = new EzySimpleSocketDataDecoder(decoder);
        this.socketReader.setDecoder(socketDataDecoder);
        this.socketWriter.setPacketQueue(this.packetQueue);
    }

    protected void startAdapters() {
        this.socketReader.setDatagramChannel(this.datagramChannel);
        this.socketReader.start();
        this.socketWriter.setDatagramChannel(this.datagramChannel);
        this.socketWriter.start();
    }

    protected void clearAdapters() {
        this.clearAdapter(this.socketReader);
        this.socketReader = null;
        this.clearAdapter(this.socketWriter);
        this.socketWriter = null;
    }

    protected void clearAdapter(EzySocketAdapter adapter) {
        if (adapter != null) {
            adapter.stop();
        }
    }

    protected void closeSocket() {
        try {
            if (this.datagramChannel != null) {
                this.datagramChannel.close();
            }
        }
        catch (Exception e) {
            this.logger.warn("close udp socket error", (Throwable)e);
        }
    }

    protected void sendHandshakeRequest() throws Exception {
        int tokenSize = this.sessionToken.length();
        int messageSize = 0;
        messageSize += 8;
        messageSize += 2;
        ByteBuffer buffer = ByteBuffer.allocate(3 + (messageSize += tokenSize));
        byte header = 0;
        header = (byte)(header | 0x20);
        buffer.put(header);
        buffer.putShort((short)messageSize);
        buffer.putLong(this.sessionId);
        buffer.putShort((short)tokenSize);
        buffer.put(this.sessionToken.getBytes());
        buffer.flip();
        this.datagramChannel.send(buffer, this.serverAddress);
    }

    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }
}

