/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client;

import com.tvd12.ezyfoxserver.client.EzyClient;
import com.tvd12.ezyfoxserver.client.EzyTcpClient;
import com.tvd12.ezyfoxserver.client.config.EzyClientConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class EzyClients {
    private String defaultClientName;
    private final Map<String, EzyClient> clients = new HashMap<String, EzyClient>();
    private static final EzyClients INSTANCE = new EzyClients();

    private EzyClients() {
    }

    public static EzyClients getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EzyClient newClient(EzyClientConfig config) {
        Map<String, EzyClient> map = this.clients;
        synchronized (map) {
            return this.newClient0(config);
        }
    }

    protected EzyClient newClient0(EzyClientConfig config) {
        String clientName = config.getClientName();
        EzyClient client = this.clients.get(clientName);
        if (client == null) {
            client = new EzyTcpClient(config);
            this.addClient0(client);
            if (this.defaultClientName == null) {
                this.defaultClientName = client.getName();
            }
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EzyClient newDefaultClient(EzyClientConfig config) {
        Map<String, EzyClient> map = this.clients;
        synchronized (map) {
            EzyClient client = this.newClient0(config);
            this.defaultClientName = client.getName();
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClient(EzyClient client) {
        Map<String, EzyClient> map = this.clients;
        synchronized (map) {
            this.addClient0(client);
        }
    }

    protected void addClient0(EzyClient client) {
        this.clients.put(client.getName(), client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EzyClient getClient(String name) {
        Map<String, EzyClient> map = this.clients;
        synchronized (map) {
            return this.getClient0(name);
        }
    }

    protected EzyClient getClient0(String name) {
        if (name == null) {
            throw new NullPointerException("can not get client with name: null");
        }
        EzyClient client = this.clients.get(name);
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EzyClient getDefaultClient() {
        Map<String, EzyClient> map = this.clients;
        synchronized (map) {
            if (this.defaultClientName == null) {
                return null;
            }
            EzyClient client = this.getClient0(this.defaultClientName);
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getClients(List<EzyClient> cachedClients) {
        cachedClients.clear();
        Map<String, EzyClient> map = this.clients;
        synchronized (map) {
            cachedClients.addAll(this.clients.values());
        }
    }
}

