/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.config;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfoxserver.client.config.EzyClientConfig;

public class EzyReconnectConfig {
    private final boolean enable;
    private final int maxReconnectCount;
    private final int reconnectPeriod;

    protected EzyReconnectConfig(Builder builder) {
        this.enable = builder.enable;
        this.reconnectPeriod = builder.reconnectPeriod;
        this.maxReconnectCount = builder.maxReconnectCount;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public int getMaxReconnectCount() {
        return this.maxReconnectCount;
    }

    public int getReconnectPeriod() {
        return this.reconnectPeriod;
    }

    public static class Builder
    implements EzyBuilder<EzyReconnectConfig> {
        private boolean enable = true;
        private int maxReconnectCount = 5;
        private int reconnectPeriod = 3000;
        private EzyClientConfig.Builder parent;

        public Builder(EzyClientConfig.Builder parent) {
            this.parent = parent;
        }

        public Builder enable(boolean enable) {
            this.enable = enable;
            return this;
        }

        public Builder reconnectPeriod(int reconnectPeriod) {
            this.reconnectPeriod = reconnectPeriod;
            return this;
        }

        public Builder maxReconnectCount(int maxReconnectCount) {
            this.maxReconnectCount = maxReconnectCount;
            return this;
        }

        public EzyClientConfig.Builder done() {
            return this.parent;
        }

        public EzyReconnectConfig build() {
            return new EzyReconnectConfig(this);
        }
    }
}

