/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.entity;

import com.tvd12.ezyfox.builder.EzyArrayBuilder;
import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.entity.EzyData;
import com.tvd12.ezyfox.entity.EzyEntity;
import com.tvd12.ezyfox.factory.EzyEntityFactory;
import com.tvd12.ezyfox.util.EzyEquals;
import com.tvd12.ezyfoxserver.client.EzyClient;
import com.tvd12.ezyfoxserver.client.constant.EzyCommand;
import com.tvd12.ezyfoxserver.client.entity.EzyPlugin;
import com.tvd12.ezyfoxserver.client.entity.EzyZone;
import com.tvd12.ezyfoxserver.client.handler.EzyPluginDataHandler;
import com.tvd12.ezyfoxserver.client.handler.EzyPluginDataHandlers;
import com.tvd12.ezyfoxserver.client.request.EzyRequest;

public class EzySimplePlugin
extends EzyEntity
implements EzyPlugin {
    protected final int id;
    protected final String name;
    protected final EzyZone zone;
    protected final EzyClient client;
    protected final EzyPluginDataHandlers dataHandlers;

    public EzySimplePlugin(EzyZone zone, int id, String name) {
        this.client = zone.getClient();
        this.zone = zone;
        this.id = id;
        this.name = name;
        this.dataHandlers = this.client.getHandlerManager().getPluginDataHandlers(name);
    }

    @Override
    public void send(EzyRequest request) {
        String cmd = (String)request.getCommand();
        EzyData data = request.serialize();
        this.send(cmd, data);
    }

    @Override
    public void send(String cmd) {
        this.send(cmd, (EzyData)EzyEntityFactory.EMPTY_OBJECT);
    }

    @Override
    public void send(String cmd, EzyData data) {
        EzyArrayBuilder commandData = EzyEntityFactory.newArrayBuilder().append((Object)cmd).append((Object)data);
        EzyArray requestData = (EzyArray)EzyEntityFactory.newArrayBuilder().append((Object)this.id).append(commandData.build()).build();
        this.client.send(EzyCommand.APP_REQUEST, requestData);
    }

    @Override
    public void udpSend(EzyRequest request) {
        String cmd = (String)request.getCommand();
        EzyData data = request.serialize();
        this.udpSend(cmd, data);
    }

    @Override
    public void udpSend(String cmd) {
        this.udpSend(cmd, (EzyData)EzyEntityFactory.EMPTY_OBJECT);
    }

    @Override
    public void udpSend(String cmd, EzyData data) {
        EzyArrayBuilder commandData = EzyEntityFactory.newArrayBuilder().append((Object)cmd).append((Object)data);
        EzyArray requestData = (EzyArray)EzyEntityFactory.newArrayBuilder().append((Object)this.id).append(commandData.build()).build();
        this.client.udpSend(EzyCommand.APP_REQUEST, requestData);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public EzyClient getClient() {
        return this.client;
    }

    @Override
    public EzyZone getZone() {
        return this.zone;
    }

    @Override
    public EzyPluginDataHandler<?> getDataHandler(Object cmd) {
        EzyPluginDataHandler handler = this.dataHandlers.getHandler(cmd);
        return handler;
    }

    public boolean equals(Object obj) {
        return new EzyEquals().function(t -> t.id).isEquals((Object)this, obj);
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "Plugin(" + "id: " + this.id + ", " + "name: " + this.name + ")";
    }
}

