/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.util;

import java.util.List;
import java.util.Stack;

public class EzyValueStack<V> {
    protected V topValue;
    protected V lastValue;
    protected V defaultValue;
    protected final Stack<V> values = new Stack();

    public EzyValueStack(V defValue) {
        this.topValue = defValue;
        this.lastValue = defValue;
        this.defaultValue = defValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V top() {
        EzyValueStack ezyValueStack = this;
        synchronized (ezyValueStack) {
            return this.topValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V last() {
        EzyValueStack ezyValueStack = this;
        synchronized (ezyValueStack) {
            return this.lastValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V pop() {
        EzyValueStack ezyValueStack = this;
        synchronized (ezyValueStack) {
            int size = this.values.size();
            this.topValue = size > 0 ? this.values.pop() : this.defaultValue;
            return this.topValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popAll(List<V> buffer) {
        EzyValueStack ezyValueStack = this;
        synchronized (ezyValueStack) {
            while (this.values.size() > 0) {
                buffer.add(this.values.pop());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(V value) {
        EzyValueStack ezyValueStack = this;
        synchronized (ezyValueStack) {
            this.topValue = value;
            this.lastValue = value;
            this.values.push(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        EzyValueStack ezyValueStack = this;
        synchronized (ezyValueStack) {
            this.topValue = this.defaultValue;
            this.lastValue = this.defaultValue;
            this.values.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        EzyValueStack ezyValueStack = this;
        synchronized (ezyValueStack) {
            int size = this.values.size();
            return size;
        }
    }
}

