/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.socket;

import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.client.codec.EzyCodecFactory;
import com.tvd12.ezyfoxserver.client.codec.EzySimpleCodecFactory;
import com.tvd12.ezyfoxserver.client.config.EzyReconnectConfig;
import com.tvd12.ezyfoxserver.client.constant.EzyCommand;
import com.tvd12.ezyfoxserver.client.constant.EzyConnectionFailedReason;
import com.tvd12.ezyfoxserver.client.constant.EzyConnectionType;
import com.tvd12.ezyfoxserver.client.constant.EzyDisconnectReason;
import com.tvd12.ezyfoxserver.client.constant.EzySocketStatus;
import com.tvd12.ezyfoxserver.client.constant.EzySocketStatuses;
import com.tvd12.ezyfoxserver.client.event.EzyConnectionFailureEvent;
import com.tvd12.ezyfoxserver.client.event.EzyConnectionSuccessEvent;
import com.tvd12.ezyfoxserver.client.event.EzyDisconnectionEvent;
import com.tvd12.ezyfoxserver.client.event.EzyEvent;
import com.tvd12.ezyfoxserver.client.event.EzyTryConnectEvent;
import com.tvd12.ezyfoxserver.client.handler.EzyDataHandlers;
import com.tvd12.ezyfoxserver.client.handler.EzyEventHandlers;
import com.tvd12.ezyfoxserver.client.manager.EzyHandlerManager;
import com.tvd12.ezyfoxserver.client.manager.EzyPingManager;
import com.tvd12.ezyfoxserver.client.socket.EzyBlockingPacketQueue;
import com.tvd12.ezyfoxserver.client.socket.EzyISocketClient;
import com.tvd12.ezyfoxserver.client.socket.EzyPacketQueue;
import com.tvd12.ezyfoxserver.client.socket.EzyPingSchedule;
import com.tvd12.ezyfoxserver.client.socket.EzyResponseApi;
import com.tvd12.ezyfoxserver.client.socket.EzySimplePackage;
import com.tvd12.ezyfoxserver.client.socket.EzySimpleSocketDataDecoder;
import com.tvd12.ezyfoxserver.client.socket.EzySimpleSocketDataEncoder;
import com.tvd12.ezyfoxserver.client.socket.EzySocketAdapter;
import com.tvd12.ezyfoxserver.client.socket.EzySocketDelegate;
import com.tvd12.ezyfoxserver.client.socket.EzySocketEventQueue;
import com.tvd12.ezyfoxserver.client.socket.EzySocketReader;
import com.tvd12.ezyfoxserver.client.socket.EzySocketResponseApi;
import com.tvd12.ezyfoxserver.client.socket.EzySocketWriter;
import com.tvd12.ezyfoxserver.client.util.EzyValueStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class EzySocketClient
extends EzyLoggable
implements EzyISocketClient,
EzySocketDelegate {
    protected String host;
    protected int port;
    protected int reconnectCount;
    protected long connectTime;
    protected int disconnectReason;
    protected long sessionId;
    protected String sessionToken;
    protected EzyReconnectConfig reconnectConfig;
    protected EzyHandlerManager handlerManager;
    protected Set<Object> unloggableCommands;
    protected EzyPingManager pingManager;
    protected EzyPingSchedule pingSchedule;
    protected EzyEventHandlers eventHandlers;
    protected EzyDataHandlers dataHandlers;
    protected EzySocketReader socketReader;
    protected EzySocketWriter socketWriter;
    protected EzyConnectionFailedReason connectionFailedReason;
    protected final EzyCodecFactory codecFactory = new EzySimpleCodecFactory();
    protected final EzyPacketQueue packetQueue = new EzyBlockingPacketQueue();
    protected final EzySocketEventQueue socketEventQueue = new EzySocketEventQueue();
    protected final EzyResponseApi responseApi = this.newResponseApi();
    protected final List<EzyEvent> localEventQueue = new ArrayList<EzyEvent>();
    protected final List<EzyArray> localMessageQueue = new ArrayList<EzyArray>();
    protected final List<EzySocketStatus> localSocketStatuses = new ArrayList<EzySocketStatus>();
    protected final EzyValueStack<EzySocketStatus> socketStatuses = new EzyValueStack<EzySocketStatus>(EzySocketStatus.NOT_CONNECT);

    private EzyResponseApi newResponseApi() {
        Object encoder = this.codecFactory.newEncoder(EzyConnectionType.SOCKET);
        EzySimpleSocketDataEncoder socketDataEncoder = new EzySimpleSocketDataEncoder(encoder);
        EzySocketResponseApi api = new EzySocketResponseApi(socketDataEncoder, this.packetQueue);
        return api;
    }

    @Override
    public void connectTo(String host, int port) {
        EzySocketStatus status = this.socketStatuses.last();
        if (!EzySocketStatuses.isSocketConnectable(status)) {
            this.logger.warn("socket is connecting...");
            return;
        }
        this.socketStatuses.push(EzySocketStatus.CONNECTING);
        this.host = host;
        this.port = port;
        this.reconnectCount = 0;
        this.connect0(0);
    }

    @Override
    public boolean reconnect() {
        EzySocketStatus status = this.socketStatuses.last();
        if (!EzySocketStatuses.isSocketReconnectable(status)) {
            this.logger.warn("socket is not in a reconnectable status");
            return false;
        }
        int maxReconnectCount = this.reconnectConfig.getMaxReconnectCount();
        if (this.reconnectCount >= maxReconnectCount) {
            return false;
        }
        this.socketStatuses.push(EzySocketStatus.RECONNECTING);
        int reconnectSleepTime = this.reconnectConfig.getReconnectPeriod();
        this.connect0(reconnectSleepTime);
        ++this.reconnectCount;
        this.logger.info("try reconnect to server: " + this.reconnectCount + ", wating time: " + reconnectSleepTime);
        EzyTryConnectEvent tryConnectEvent = new EzyTryConnectEvent(this.reconnectCount);
        this.socketEventQueue.addEvent(tryConnectEvent);
        return true;
    }

    protected void connect0(final int sleepTime) {
        this.clearAdapters();
        this.createAdapters();
        this.updateAdapters();
        this.closeSocket();
        this.packetQueue.clear();
        this.socketEventQueue.clear();
        this.socketStatuses.clear();
        this.disconnectReason = EzyDisconnectReason.UNKNOWN.getId();
        this.connectionFailedReason = EzyConnectionFailedReason.UNKNOWN;
        Thread newThread = new Thread(new Runnable(){

            @Override
            public void run() {
                EzySocketClient.this.connect1(sleepTime);
            }
        });
        newThread.setName("ezyfox-connection");
        newThread.start();
    }

    protected void connect1(int sleepTime) {
        int minSleepTimeBeforeReconnect;
        long currentTime = System.currentTimeMillis();
        long dt = currentTime - this.connectTime;
        long realSleepTime = sleepTime;
        if (sleepTime <= 0 && dt < (long)(minSleepTimeBeforeReconnect = this.minSleepTimeBeforeReconnect())) {
            realSleepTime = (long)minSleepTimeBeforeReconnect - dt;
        }
        if (realSleepTime >= 0L) {
            this.sleepBeforeConnect(realSleepTime);
        }
        this.socketStatuses.push(EzySocketStatus.CONNECTING);
        boolean success = this.connectNow();
        this.connectTime = System.currentTimeMillis();
        if (success) {
            this.reconnectCount = 0;
            this.startAdapters();
            this.socketStatuses.push(EzySocketStatus.CONNECTED);
        } else {
            this.resetSocket();
            this.socketStatuses.push(EzySocketStatus.CONNECT_FAILED);
        }
    }

    protected int minSleepTimeBeforeReconnect() {
        return 2000;
    }

    protected void sleepBeforeConnect(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected abstract boolean connectNow();

    protected abstract void createAdapters();

    protected void updateAdapters() {
        Object decoder = this.codecFactory.newDecoder(EzyConnectionType.SOCKET);
        EzySimpleSocketDataDecoder socketDataDecoder = new EzySimpleSocketDataDecoder(decoder);
        this.socketReader.setDecoder(socketDataDecoder);
        this.socketWriter.setPacketQueue(this.packetQueue);
    }

    protected abstract void startAdapters();

    protected void clearAdapters() {
        this.clearAdapter(this.socketReader);
        this.clearAdapter(this.socketWriter);
        this.socketReader = null;
        this.socketWriter = null;
    }

    protected void clearAdapter(EzySocketAdapter adapter) {
        if (adapter != null) {
            adapter.stop();
        }
    }

    protected void clearComponents(int disconnectReason) {
    }

    protected abstract void resetSocket();

    protected abstract void closeSocket();

    @Override
    public void onDisconnected(int reason) {
        this.pingSchedule.stop();
        this.packetQueue.clear();
        this.packetQueue.wakeup();
        this.socketEventQueue.clear();
        this.closeSocket();
        this.clearAdapters();
        this.clearComponents(reason);
        this.socketStatuses.push(EzySocketStatus.DISCONNECTED);
    }

    @Override
    public void disconnect(int reason) {
        if (this.socketStatuses.last() != EzySocketStatus.CONNECTED) {
            return;
        }
        this.disconnectReason = reason;
        this.onDisconnected(this.disconnectReason);
    }

    @Override
    public void close() {
        this.disconnect(EzyDisconnectReason.CLOSE.getId());
        this.pingSchedule.shutdown();
    }

    @Override
    public void sendMessage(EzyArray message) {
        EzySimplePackage pack = new EzySimplePackage(message);
        try {
            this.responseApi.response(pack);
        }
        catch (Exception e) {
            this.logger.warn("send message: " + message + " error", (Throwable)e);
        }
    }

    public void processEventMessages() {
        this.processStatuses();
        this.processEvents();
        this.processReceivedMessages();
    }

    protected void processStatuses() {
        this.socketStatuses.popAll(this.localSocketStatuses);
        for (int i = 0; i < this.localSocketStatuses.size(); ++i) {
            EzyEvent evt;
            EzySocketStatus status = this.localSocketStatuses.get(i);
            if (status == EzySocketStatus.CONNECTED) {
                evt = new EzyConnectionSuccessEvent();
                this.socketEventQueue.addEvent(evt);
                continue;
            }
            if (status == EzySocketStatus.CONNECT_FAILED) {
                evt = new EzyConnectionFailureEvent(this.connectionFailedReason);
                this.socketEventQueue.addEvent(evt);
                break;
            }
            if (status != EzySocketStatus.DISCONNECTED) continue;
            evt = new EzyDisconnectionEvent(this.disconnectReason);
            this.socketEventQueue.addEvent(evt);
            break;
        }
        this.localSocketStatuses.clear();
    }

    protected void processEvents() {
        this.socketEventQueue.popAll(this.localEventQueue);
        try {
            for (int i = 0; i < this.localEventQueue.size(); ++i) {
                EzyEvent evt = this.localEventQueue.get(i);
                this.eventHandlers.handle(evt);
            }
        }
        finally {
            this.localEventQueue.clear();
        }
    }

    protected void processReceivedMessages() {
        EzySocketStatus statusLast;
        EzySocketStatus status = this.socketStatuses.last();
        if (status == EzySocketStatus.CONNECTED && this.socketReader.isActive()) {
            this.processReceivedMessages0();
        }
        if (EzySocketStatuses.isSocketDisconnectable(statusLast = this.socketStatuses.last())) {
            if (this.socketReader.isStopped()) {
                this.onDisconnected(this.disconnectReason);
            } else if (this.socketWriter.isStopped()) {
                this.onDisconnected(this.disconnectReason);
            }
        }
    }

    protected void processReceivedMessages0() {
        this.pingManager.setLostPingCount(0);
        this.popReadMessages();
        try {
            for (int i = 0; i < this.localMessageQueue.size(); ++i) {
                this.processReceivedMessage(this.localMessageQueue.get(i));
            }
        }
        finally {
            this.localMessageQueue.clear();
        }
    }

    protected void popReadMessages() {
        this.socketReader.popMessages(this.localMessageQueue);
    }

    protected void processReceivedMessage(EzyArray message) {
        int cmdId = (Integer)message.get(0, Integer.TYPE);
        EzyArray data = (EzyArray)message.get(1, EzyArray.class, null);
        EzyCommand cmd = EzyCommand.valueOf(cmdId);
        this.printReceivedData(cmd, data);
        if (cmd == EzyCommand.DISCONNECT) {
            int reasonId;
            this.disconnectReason = reasonId = ((Integer)data.get(0, Integer.TYPE)).intValue();
            this.socketStatuses.push(EzySocketStatus.DISCONNECTING);
        } else {
            this.dataHandlers.handle((Object)cmd, data);
        }
    }

    protected void printReceivedData(EzyCommand cmd, EzyArray data) {
        if (!this.unloggableCommands.contains((Object)cmd)) {
            this.logger.debug("received command: " + (Object)((Object)cmd) + " and data: " + data);
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public void setPingManager(EzyPingManager pingManager) {
        this.pingManager = pingManager;
    }

    public void setPingSchedule(EzyPingSchedule pingSchedule) {
        this.pingSchedule = pingSchedule;
        this.pingSchedule.setSocketEventQueue(this.socketEventQueue);
    }

    public void setHandlerManager(EzyHandlerManager handlerManager) {
        this.handlerManager = handlerManager;
        this.dataHandlers = handlerManager.getDataHandlers();
        this.eventHandlers = handlerManager.getEventHandlers();
    }

    public void setReconnectConfig(EzyReconnectConfig reconnectConfig) {
        this.reconnectConfig = reconnectConfig;
    }

    public void setUnloggableCommands(Set<Object> unloggableCommands) {
        this.unloggableCommands = unloggableCommands;
    }
}

