/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.socket;

import com.tvd12.ezyfox.codec.EzyMessage;
import com.tvd12.ezyfox.codec.EzyMessageReaders;
import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfoxserver.client.concurrent.EzySynchronizedQueue;
import com.tvd12.ezyfoxserver.client.socket.EzySocketAdapter;
import com.tvd12.ezyfoxserver.client.socket.EzySocketDataDecoder;
import com.tvd12.ezyfoxserver.client.util.EzyQueue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.List;

public class EzyUdpSocketReader
extends EzySocketAdapter {
    protected final ByteBuffer buffer;
    protected final int readBufferSize;
    protected final EzyQueue<EzyArray> dataQueue = new EzySynchronizedQueue<EzyArray>();
    protected EzySocketDataDecoder decoder;
    protected DatagramChannel datagramChannel;

    public EzyUdpSocketReader() {
        this.readBufferSize = 8192;
        this.buffer = ByteBuffer.allocateDirect(this.readBufferSize);
    }

    @Override
    protected void update() {
        try {
            while (true) {
                if (!this.active) {
                    return;
                }
                this.buffer.clear();
                int bytesToRead = this.readSocketData();
                if (bytesToRead <= 0) {
                    return;
                }
                this.buffer.flip();
                byte[] binary = new byte[this.buffer.limit()];
                this.buffer.get(binary);
                this.handleReceivedBytes(binary);
            }
        }
        catch (InterruptedException e) {
            this.logger.debug("socket reader interrupted", (Throwable)e);
            return;
        }
        catch (IOException e) {
            this.logger.warn("I/O error at socket-reader", (Throwable)e);
            return;
        }
        catch (Exception e) {
            this.logger.warn("I/O error at socket-reader", (Throwable)e);
            return;
        }
    }

    protected int readSocketData() throws Exception {
        try {
            this.datagramChannel.receive(this.buffer);
            int readBytes = this.buffer.position();
            return readBytes;
        }
        catch (Exception e) {
            this.handleSocketReaderException(e);
            return -1;
        }
    }

    protected void handleReceivedBytes(byte[] bytes) {
        EzyMessage message = EzyMessageReaders.bytesToMessage((byte[])bytes);
        if (message == null) {
            return;
        }
        this.onMesssageReceived(message);
    }

    @Override
    protected void clear() {
        if (this.dataQueue != null) {
            this.dataQueue.clear();
        }
    }

    public void popMessages(List<EzyArray> buffer) {
        this.dataQueue.pollAll(buffer);
    }

    private void onMesssageReceived(EzyMessage message) {
        try {
            Object data = this.decoder.decode(message);
            this.dataQueue.add((EzyArray)data);
        }
        catch (Exception e) {
            this.logger.warn("decode error at socket-reader", (Throwable)e);
        }
    }

    public void setDecoder(EzySocketDataDecoder decoder) {
        this.decoder = decoder;
    }

    public void setDatagramChannel(DatagramChannel datagramChannel) {
        this.datagramChannel = datagramChannel;
    }

    @Override
    protected String getThreadName() {
        return "udp-socket-reader";
    }
}

