/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.manager;

import com.tvd12.ezyfox.constant.EzyConstant;
import com.tvd12.ezyfoxserver.client.EzyClient;
import com.tvd12.ezyfoxserver.client.constant.EzyCommand;
import com.tvd12.ezyfoxserver.client.event.EzyEventType;
import com.tvd12.ezyfoxserver.client.handler.EzyAppAccessHandler;
import com.tvd12.ezyfoxserver.client.handler.EzyAppDataHandlers;
import com.tvd12.ezyfoxserver.client.handler.EzyAppExitHandler;
import com.tvd12.ezyfoxserver.client.handler.EzyAppResponseHandler;
import com.tvd12.ezyfoxserver.client.handler.EzyConnectionFailureHandler;
import com.tvd12.ezyfoxserver.client.handler.EzyConnectionSuccessHandler;
import com.tvd12.ezyfoxserver.client.handler.EzyDataHandler;
import com.tvd12.ezyfoxserver.client.handler.EzyDataHandlers;
import com.tvd12.ezyfoxserver.client.handler.EzyDisconnectionHandler;
import com.tvd12.ezyfoxserver.client.handler.EzyEventHandler;
import com.tvd12.ezyfoxserver.client.handler.EzyEventHandlers;
import com.tvd12.ezyfoxserver.client.handler.EzyLoginErrorHandler;
import com.tvd12.ezyfoxserver.client.handler.EzyLoginSuccessHandler;
import com.tvd12.ezyfoxserver.client.handler.EzyPluginDataHandlers;
import com.tvd12.ezyfoxserver.client.handler.EzyPongHandler;
import com.tvd12.ezyfoxserver.client.handler.EzyUdpHandshakeHandler;
import com.tvd12.ezyfoxserver.client.manager.EzyHandlerManager;
import com.tvd12.ezyfoxserver.client.socket.EzyPingSchedule;
import java.util.HashMap;
import java.util.Map;

public class EzySimpleHandlerManager
implements EzyHandlerManager {
    private final EzyClient client;
    private final EzyPingSchedule pingSchedule;
    private final EzyEventHandlers eventHandlers;
    private final EzyDataHandlers dataHandlers;
    private final Map<String, EzyAppDataHandlers> appDataHandlerss;
    private final Map<String, EzyPluginDataHandlers> pluginDataHandlerss;

    public EzySimpleHandlerManager(EzyClient client) {
        this.client = client;
        this.pingSchedule = client.getPingSchedule();
        this.eventHandlers = this.newEventHandlers();
        this.dataHandlers = this.newDataHandlers();
        this.appDataHandlerss = new HashMap<String, EzyAppDataHandlers>();
        this.pluginDataHandlerss = new HashMap<String, EzyPluginDataHandlers>();
    }

    private EzyEventHandlers newEventHandlers() {
        EzyEventHandlers handlers = new EzyEventHandlers(this.client, this.pingSchedule);
        handlers.addHandler(EzyEventType.CONNECTION_SUCCESS, new EzyConnectionSuccessHandler());
        handlers.addHandler(EzyEventType.CONNECTION_FAILURE, new EzyConnectionFailureHandler());
        handlers.addHandler(EzyEventType.DISCONNECTION, new EzyDisconnectionHandler());
        return handlers;
    }

    private EzyDataHandlers newDataHandlers() {
        EzyDataHandlers handlers = new EzyDataHandlers(this.client, this.pingSchedule);
        handlers.addHandler((Object)EzyCommand.PONG, new EzyPongHandler());
        handlers.addHandler((Object)EzyCommand.LOGIN, new EzyLoginSuccessHandler());
        handlers.addHandler((Object)EzyCommand.LOGIN_ERROR, new EzyLoginErrorHandler());
        handlers.addHandler((Object)EzyCommand.APP_ACCESS, new EzyAppAccessHandler());
        handlers.addHandler((Object)EzyCommand.APP_REQUEST, new EzyAppResponseHandler());
        handlers.addHandler((Object)EzyCommand.APP_EXIT, new EzyAppExitHandler());
        handlers.addHandler((Object)EzyCommand.UDP_HANDSHAKE, new EzyUdpHandshakeHandler());
        return handlers;
    }

    @Override
    public EzyDataHandler getDataHandler(Object cmd) {
        return this.dataHandlers.getHandler(cmd);
    }

    @Override
    public EzyEventHandler getEventHandler(EzyConstant eventType) {
        return this.eventHandlers.getHandler(eventType);
    }

    @Override
    public EzyAppDataHandlers getAppDataHandlers(String appName) {
        EzyAppDataHandlers answer = this.appDataHandlerss.get(appName);
        if (answer == null) {
            answer = new EzyAppDataHandlers();
            this.appDataHandlerss.put(appName, answer);
        }
        return answer;
    }

    @Override
    public EzyPluginDataHandlers getPluginDataHandlers(String pluginName) {
        EzyPluginDataHandlers answer = this.pluginDataHandlerss.get(pluginName);
        if (answer == null) {
            answer = new EzyPluginDataHandlers();
            this.pluginDataHandlerss.put(pluginName, answer);
        }
        return answer;
    }

    @Override
    public void addDataHandler(Object cmd, EzyDataHandler dataHandler) {
        this.dataHandlers.addHandler(cmd, dataHandler);
    }

    @Override
    public void addEventHandler(EzyConstant eventType, EzyEventHandler eventHandler) {
        this.eventHandlers.addHandler(eventType, eventHandler);
    }

    @Override
    public EzyEventHandlers getEventHandlers() {
        return this.eventHandlers;
    }

    @Override
    public EzyDataHandlers getDataHandlers() {
        return this.dataHandlers;
    }
}

