/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.config;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfoxserver.client.config.EzyPingConfig;
import com.tvd12.ezyfoxserver.client.config.EzyReconnectConfig;
import com.tvd12.ezyfoxserver.client.config.EzySocketClientConfig;

public class EzyClientConfig
implements EzySocketClientConfig {
    private final String zoneName;
    private final String clientName;
    private final EzyPingConfig ping;
    private final boolean enableSSL;
    private final boolean enableDebug;
    private final EzyReconnectConfig reconnect;

    protected EzyClientConfig(Builder builder) {
        this.zoneName = builder.zoneName;
        this.clientName = builder.clientName;
        this.enableSSL = builder.enableSSL;
        this.enableDebug = builder.enableDebug;
        this.ping = builder.pingConfigBuilder.build();
        this.reconnect = builder.reconnectConfigBuilder.build();
    }

    public String getZoneName() {
        return this.zoneName;
    }

    public String getClientName() {
        if (this.clientName == null) {
            return this.zoneName;
        }
        return this.clientName;
    }

    public EzyPingConfig getPing() {
        return this.ping;
    }

    public EzyReconnectConfig getReconnect() {
        return this.reconnect;
    }

    @Override
    public boolean isEnableSSL() {
        return this.enableSSL;
    }

    public boolean isEnableDebug() {
        return this.enableDebug;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements EzyBuilder<EzyClientConfig> {
        private String zoneName;
        private String clientName;
        private boolean enableSSL;
        private boolean enableDebug;
        private final EzyPingConfig.Builder pingConfigBuilder = new EzyPingConfig.Builder(this);
        private final EzyReconnectConfig.Builder reconnectConfigBuilder = new EzyReconnectConfig.Builder(this);

        public Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public Builder clientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public Builder enableSSL() {
            return this.enableSSL(true);
        }

        public Builder enableSSL(boolean enableSSL) {
            this.enableSSL = enableSSL;
            return this;
        }

        public Builder enableDebug() {
            return this.enableDebug(true);
        }

        public Builder enableDebug(boolean enableDebug) {
            this.enableDebug = enableDebug;
            return this;
        }

        public EzyPingConfig.Builder pingConfigBuilder() {
            return this.pingConfigBuilder;
        }

        public EzyReconnectConfig.Builder reconnectConfigBuilder() {
            return this.reconnectConfigBuilder;
        }

        public EzyClientConfig build() {
            return new EzyClientConfig(this);
        }
    }
}

