/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.handler;

import com.tvd12.ezyfox.sercurity.EzyKeysGenerator;
import com.tvd12.ezyfoxserver.client.constant.EzyConnectionStatus;
import com.tvd12.ezyfoxserver.client.event.EzyEvent;
import com.tvd12.ezyfoxserver.client.handler.EzyAbstractEventHandler;
import com.tvd12.ezyfoxserver.client.request.EzyHandshakeRequest;
import com.tvd12.ezyfoxserver.client.request.EzyRequest;
import java.security.KeyPair;
import java.util.UUID;

public class EzyConnectionSuccessHandler
extends EzyAbstractEventHandler {
    @Override
    public final void handle(EzyEvent event) {
        this.client.setStatus(EzyConnectionStatus.CONNECTED);
        this.sendHandshakeRequest();
        this.postHandle();
    }

    protected void postHandle() {
    }

    protected void sendHandshakeRequest() {
        EzyRequest request = this.newHandshakeRequest();
        this.client.send(request);
    }

    protected final EzyRequest newHandshakeRequest() {
        EzyHandshakeRequest request = new EzyHandshakeRequest(this.getClientId(), this.generateClientKey(), "JAVA", "1.1.3", this.client.isEnableSSL(), this.getStoredToken());
        return request;
    }

    protected String getClientId() {
        String id = UUID.randomUUID().toString();
        return id;
    }

    protected byte[] generateClientKey() {
        if (!this.client.isEnableSSL()) {
            return null;
        }
        KeyPair keyPair = EzyKeysGenerator.builder().build().generate();
        byte[] publicKey = keyPair.getPublic().getEncoded();
        byte[] privateKey = keyPair.getPrivate().getEncoded();
        this.client.setPublicKey(publicKey);
        this.client.setPrivateKey(privateKey);
        return publicKey;
    }

    protected String getStoredToken() {
        return "";
    }
}

