/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.socket;

import com.tvd12.ezyfoxserver.client.config.EzySocketClientConfig;
import com.tvd12.ezyfoxserver.client.constant.EzyConnectionFailedReason;
import com.tvd12.ezyfoxserver.client.socket.EzySocketClient;
import com.tvd12.ezyfoxserver.client.socket.EzyTcpSocketReader;
import com.tvd12.ezyfoxserver.client.socket.EzyTcpSocketWriter;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;

public class EzyTcpSocketClient
extends EzySocketClient {
    protected SocketChannel socket;

    public EzyTcpSocketClient(EzySocketClientConfig config) {
        super(config);
    }

    @Override
    protected boolean connectNow() {
        try {
            InetSocketAddress socketAddress = new InetSocketAddress(this.host, this.port);
            this.socket = SocketChannel.open();
            this.socket.connect(socketAddress);
            this.socket.configureBlocking(true);
            return true;
        }
        catch (Exception e) {
            ConnectException c;
            this.connectionFailedReason = e instanceof ConnectException ? ("Network is unreachable".equalsIgnoreCase((c = (ConnectException)e).getMessage()) ? EzyConnectionFailedReason.NETWORK_UNREACHABLE : EzyConnectionFailedReason.CONNECTION_REFUSED) : (e instanceof UnknownHostException ? EzyConnectionFailedReason.UNKNOWN_HOST : EzyConnectionFailedReason.UNKNOWN);
            return false;
        }
    }

    @Override
    protected void createAdapters() {
        this.socketReader = new EzyTcpSocketReader();
        this.socketWriter = new EzyTcpSocketWriter();
    }

    @Override
    protected void startAdapters() {
        ((EzyTcpSocketReader)this.socketReader).setSocket(this.socket);
        this.socketReader.start();
        ((EzyTcpSocketWriter)this.socketWriter).setSocket(this.socket);
        this.socketWriter.start();
    }

    @Override
    protected void resetSocket() {
        this.socket = null;
    }

    @Override
    protected void closeSocket() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception e) {
            this.logger.warn("close socket error", (Throwable)e);
        }
    }
}

