/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client;

import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.entity.EzyData;
import com.tvd12.ezyfox.entity.EzyEntity;
import com.tvd12.ezyfoxserver.client.EzyClient;
import com.tvd12.ezyfoxserver.client.config.EzyClientConfig;
import com.tvd12.ezyfoxserver.client.config.EzySocketClientConfig;
import com.tvd12.ezyfoxserver.client.constant.EzyCommand;
import com.tvd12.ezyfoxserver.client.constant.EzyConnectionStatus;
import com.tvd12.ezyfoxserver.client.constant.EzyConnectionStatuses;
import com.tvd12.ezyfoxserver.client.entity.EzyApp;
import com.tvd12.ezyfoxserver.client.entity.EzyMeAware;
import com.tvd12.ezyfoxserver.client.entity.EzyUser;
import com.tvd12.ezyfoxserver.client.entity.EzyZone;
import com.tvd12.ezyfoxserver.client.entity.EzyZoneAware;
import com.tvd12.ezyfoxserver.client.manager.EzyAppManager;
import com.tvd12.ezyfoxserver.client.manager.EzyHandlerManager;
import com.tvd12.ezyfoxserver.client.manager.EzyPingManager;
import com.tvd12.ezyfoxserver.client.manager.EzySimpleHandlerManager;
import com.tvd12.ezyfoxserver.client.manager.EzySimplePingManager;
import com.tvd12.ezyfoxserver.client.request.EzyRequest;
import com.tvd12.ezyfoxserver.client.request.EzyRequestSerializer;
import com.tvd12.ezyfoxserver.client.request.EzySimpleRequestSerializer;
import com.tvd12.ezyfoxserver.client.setup.EzySetup;
import com.tvd12.ezyfoxserver.client.setup.EzySimpleSetup;
import com.tvd12.ezyfoxserver.client.socket.EzyPingSchedule;
import com.tvd12.ezyfoxserver.client.socket.EzySocketClient;
import com.tvd12.ezyfoxserver.client.socket.EzyTcpSocketClient;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EzyTcpClient
extends EzyEntity
implements EzyClient,
EzyMeAware,
EzyZoneAware {
    protected final String name;
    protected final EzySetup settingUp;
    protected final EzyClientConfig config;
    protected final EzyPingManager pingManager;
    protected final EzyHandlerManager handlerManager;
    protected final EzyRequestSerializer requestSerializer;
    protected final Set<Object> ignoredLogCommands;
    protected final EzySocketClient socketClient;
    protected final EzyPingSchedule pingSchedule;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected EzyUser me;
    protected EzyZone zone;
    protected long sessionId;
    protected byte[] publicKey;
    protected byte[] privateKey;
    protected byte[] sessionKey;
    protected String sessionToken;
    protected EzyConnectionStatus status;
    protected EzyConnectionStatus udpStatus;

    public EzyTcpClient(EzyClientConfig config) {
        this.config = config;
        this.name = config.getClientName();
        this.status = EzyConnectionStatus.NULL;
        this.pingManager = new EzySimplePingManager(config.getPing());
        this.pingSchedule = new EzyPingSchedule(this);
        this.handlerManager = new EzySimpleHandlerManager(this);
        this.requestSerializer = new EzySimpleRequestSerializer();
        this.settingUp = new EzySimpleSetup(this.handlerManager);
        this.ignoredLogCommands = this.newIgnoredLogCommands();
        this.socketClient = this.newSocketClient();
    }

    protected Set<Object> newIgnoredLogCommands() {
        HashSet<Object> set = new HashSet<Object>();
        set.add((Object)EzyCommand.PING);
        set.add((Object)EzyCommand.PONG);
        return set;
    }

    protected EzySocketClient newSocketClient() {
        EzyTcpSocketClient client = this.newTcpSocketClient(this.config);
        client.setPingSchedule(this.pingSchedule);
        client.setPingManager(this.pingManager);
        client.setHandlerManager(this.handlerManager);
        client.setReconnectConfig(this.config.getReconnect());
        client.setIgnoredLogCommands(this.ignoredLogCommands);
        return client;
    }

    protected EzyTcpSocketClient newTcpSocketClient(EzySocketClientConfig config) {
        return new EzyTcpSocketClient(config);
    }

    @Override
    public EzySetup setup() {
        return this.settingUp;
    }

    @Override
    public void connect(String host, int port) {
        try {
            if (!EzyConnectionStatuses.isClientConnectable(this.status)) {
                this.logger.warn("client has already connected to: " + host + ":" + port);
                return;
            }
            this.preConnect();
            this.socketClient.connectTo(host, port);
            this.setStatus(EzyConnectionStatus.CONNECTING);
        }
        catch (Exception e) {
            this.logger.error("connect to server error", (Throwable)e);
        }
    }

    @Override
    public boolean reconnect() {
        if (!EzyConnectionStatuses.isClientReconnectable(this.status)) {
            String host = this.socketClient.getHost();
            int port = this.socketClient.getPort();
            this.logger.warn("client has already connected to: " + host + ":" + port);
            return false;
        }
        this.preConnect();
        boolean success = this.socketClient.reconnect();
        if (success) {
            this.setStatus(EzyConnectionStatus.RECONNECTING);
        }
        return success;
    }

    protected void preConnect() {
        this.me = null;
        this.zone = null;
        this.publicKey = null;
        this.privateKey = null;
        this.sessionKey = null;
    }

    @Override
    public void disconnect(int reason) {
        this.socketClient.disconnect(reason);
    }

    @Override
    public void send(EzyRequest request) {
        this.send(request, false);
    }

    @Override
    public void send(EzyRequest request, boolean encrypted) {
        Object cmd = request.getCommand();
        EzyData data = request.serialize();
        this.send((EzyCommand)((Object)cmd), (EzyArray)data, encrypted);
    }

    @Override
    public void send(EzyCommand cmd, EzyArray data) {
        this.send(cmd, data, false);
    }

    @Override
    public void send(EzyCommand cmd, EzyArray data, boolean encrypted) {
        boolean shouldEncrypted = encrypted;
        if (encrypted && this.sessionKey == null) {
            if (this.config.isEnableDebug()) {
                shouldEncrypted = false;
            } else {
                throw new IllegalArgumentException("can not send command: " + (Object)((Object)cmd) + " you must enable SSL or enable debug mode by configuration when you create the client");
            }
        }
        EzyArray array = this.requestSerializer.serialize(cmd, data);
        this.socketClient.sendMessage(array, shouldEncrypted);
        this.printSentData(cmd, data);
    }

    @Override
    public void processEvents() {
        this.socketClient.processEventMessages();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public EzyClientConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean isEnableSSL() {
        return this.config.isEnableSSL();
    }

    @Override
    public boolean isEnableDebug() {
        return this.config.isEnableDebug();
    }

    @Override
    public EzyZone getZone() {
        return this.zone;
    }

    @Override
    public void setZone(EzyZone zone) {
        this.zone = zone;
    }

    @Override
    public EzyUser getMe() {
        return this.me;
    }

    @Override
    public void setMe(EzyUser me) {
        this.me = me;
    }

    @Override
    public EzyConnectionStatus getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(EzyConnectionStatus status) {
        this.status = status;
    }

    @Override
    public EzyConnectionStatus getUdpStatus() {
        return this.udpStatus;
    }

    @Override
    public void setUdpStatus(EzyConnectionStatus status) {
        this.udpStatus = status;
    }

    @Override
    public long getSessionId() {
        return this.sessionId;
    }

    @Override
    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
        this.socketClient.setSessionId(sessionId);
    }

    @Override
    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    public void setSessionToken(String token) {
        this.sessionToken = token;
        this.socketClient.setSessionToken(this.sessionToken);
    }

    @Override
    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    @Override
    public void setSessionKey(byte[] sessionKey) {
        this.sessionKey = sessionKey;
        this.socketClient.setSessionKey(sessionKey);
    }

    @Override
    public byte[] getPublicKey() {
        return this.publicKey;
    }

    @Override
    public void setPublicKey(byte[] publicKey) {
        this.publicKey = publicKey;
    }

    @Override
    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public void setPrivateKey(byte[] privateKey) {
        this.privateKey = privateKey;
    }

    @Override
    public EzySocketClient getSocket() {
        return this.socketClient;
    }

    @Override
    public EzyApp getApp() {
        if (this.zone != null) {
            EzyAppManager appManager = this.zone.getAppManager();
            return appManager.getApp();
        }
        return null;
    }

    @Override
    public EzyApp getAppById(int appId) {
        if (this.zone != null) {
            EzyAppManager appManager = this.zone.getAppManager();
            return appManager.getAppById(appId);
        }
        return null;
    }

    @Override
    public EzyPingManager getPingManager() {
        return this.pingManager;
    }

    @Override
    public EzyPingSchedule getPingSchedule() {
        return this.pingSchedule;
    }

    @Override
    public EzyHandlerManager getHandlerManager() {
        return this.handlerManager;
    }

    protected void printSentData(EzyCommand cmd, EzyArray data) {
        if (!this.ignoredLogCommands.contains((Object)cmd)) {
            this.logger.debug("send command: " + (Object)((Object)cmd) + " and data: " + data);
        }
    }

    @Override
    public void udpConnect(int port) {
        throw new UnsupportedOperationException("only support TCP, use EzyUTClient instead");
    }

    @Override
    public void udpConnect(String host, int port) {
        throw new UnsupportedOperationException("only support TCP, use EzyUTClient instead");
    }

    @Override
    public void udpSend(EzyRequest request) {
        throw new UnsupportedOperationException("only support TCP, use EzyUTClient instead");
    }

    @Override
    public void udpSend(EzyCommand cmd, EzyArray data) {
        throw new UnsupportedOperationException("only support TCP, use EzyUTClient instead");
    }

    @Override
    public void close() {
        this.socketClient.close();
    }
}

