/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class EzyQueue<E> {
    protected final int capacity;
    protected final Queue<E> queue;

    public EzyQueue() {
        this(Integer.MAX_VALUE);
    }

    public EzyQueue(int capacity) {
        this.capacity = capacity;
        this.queue = this.newQueue(capacity);
    }

    protected Queue<E> newQueue(int capacity) {
        return new LinkedList();
    }

    public boolean add(E e) {
        if (this.queue.size() >= this.capacity) {
            return false;
        }
        this.queue.offer(e);
        return true;
    }

    public boolean offer(E e) {
        return this.add(e);
    }

    public E peek() {
        return this.queue.peek();
    }

    public E poll() {
        return this.queue.poll();
    }

    public void pollAll(List<E> list) {
        while (this.queue.size() > 0) {
            list.add(this.queue.poll());
        }
    }

    public int size() {
        return this.queue.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        this.queue.clear();
    }

    public int getCapacity() {
        return this.capacity;
    }
}

