/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.handler;

import com.tvd12.ezyfoxserver.client.config.EzyClientConfig;
import com.tvd12.ezyfoxserver.client.config.EzyReconnectConfig;
import com.tvd12.ezyfoxserver.client.constant.EzyConnectionStatus;
import com.tvd12.ezyfoxserver.client.constant.EzyDisconnectReason;
import com.tvd12.ezyfoxserver.client.constant.EzyDisconnectReasons;
import com.tvd12.ezyfoxserver.client.event.EzyDisconnectionEvent;
import com.tvd12.ezyfoxserver.client.handler.EzyAbstractEventHandler;

public class EzyDisconnectionHandler
extends EzyAbstractEventHandler<EzyDisconnectionEvent> {
    @Override
    public final void handle(EzyDisconnectionEvent event) {
        String reasonName = EzyDisconnectReasons.getDisconnectReasonName(event.getReason());
        this.logger.info("handle disconnection, reason: {}", (Object)reasonName);
        this.preHandle(event);
        EzyClientConfig config = this.client.getConfig();
        EzyReconnectConfig reconnectConfig = config.getReconnect();
        boolean shouldReconnect = this.shouldReconnect(event);
        boolean mustReconnect = reconnectConfig.isEnable() && event.getReason() != EzyDisconnectReason.UNAUTHORIZED.getId() && event.getReason() != EzyDisconnectReason.CLOSE.getId() && shouldReconnect;
        boolean reconnecting = false;
        this.client.setStatus(EzyConnectionStatus.DISCONNECTED);
        this.client.setUdpStatus(EzyConnectionStatus.DISCONNECTED);
        if (mustReconnect) {
            reconnecting = this.client.reconnect();
        }
        if (reconnecting) {
            this.onReconnecting(event);
        } else {
            this.onDisconnected(event);
        }
        this.postHandle(event);
    }

    protected void preHandle(EzyDisconnectionEvent event) {
    }

    protected void onReconnecting(EzyDisconnectionEvent event) {
    }

    protected void onDisconnected(EzyDisconnectionEvent event) {
    }

    protected void postHandle(EzyDisconnectionEvent event) {
    }

    protected boolean shouldReconnect(EzyDisconnectionEvent event) {
        int reason = event.getReason();
        return reason != EzyDisconnectReason.ANOTHER_SESSION_LOGIN.getId();
    }
}

