/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.setup;

import com.tvd12.ezyfoxserver.client.event.EzyEventType;
import com.tvd12.ezyfoxserver.client.handler.EzyAppDataHandlers;
import com.tvd12.ezyfoxserver.client.handler.EzyDataHandler;
import com.tvd12.ezyfoxserver.client.handler.EzyEventHandler;
import com.tvd12.ezyfoxserver.client.handler.EzyPluginDataHandlers;
import com.tvd12.ezyfoxserver.client.manager.EzyHandlerManager;
import com.tvd12.ezyfoxserver.client.setup.EzyAppSetup;
import com.tvd12.ezyfoxserver.client.setup.EzyPluginSetup;
import com.tvd12.ezyfoxserver.client.setup.EzySetup;
import com.tvd12.ezyfoxserver.client.setup.EzySimpleAppSetup;
import com.tvd12.ezyfoxserver.client.setup.EzySimplePluginSetup;
import java.util.HashMap;
import java.util.Map;

public class EzySimpleSetup
implements EzySetup {
    private final EzyHandlerManager handlerManager;
    private final Map<String, EzyAppSetup> appSetups;
    private final Map<String, EzyPluginSetup> pluginSetups;

    public EzySimpleSetup(EzyHandlerManager handlerManager) {
        this.handlerManager = handlerManager;
        this.appSetups = new HashMap<String, EzyAppSetup>();
        this.pluginSetups = new HashMap<String, EzyPluginSetup>();
    }

    @Override
    public EzySetup addDataHandler(Object cmd, EzyDataHandler dataHandler) {
        this.handlerManager.addDataHandler(cmd, dataHandler);
        return this;
    }

    @Override
    public EzySetup addEventHandler(EzyEventType eventType, EzyEventHandler eventHandler) {
        this.handlerManager.addEventHandler(eventType, eventHandler);
        return this;
    }

    @Override
    public EzyAppSetup setupApp(String appName) {
        EzyAppSetup appSetup = this.appSetups.get(appName);
        if (appSetup == null) {
            EzyAppDataHandlers dataHandlers = this.handlerManager.getAppDataHandlers(appName);
            appSetup = new EzySimpleAppSetup(dataHandlers, this);
            this.appSetups.put(appName, appSetup);
        }
        return appSetup;
    }

    @Override
    public EzyPluginSetup setupPlugin(String pluginName) {
        EzyPluginSetup pluginSetup = this.pluginSetups.get(pluginName);
        if (pluginSetup == null) {
            EzyPluginDataHandlers dataHandlers = this.handlerManager.getPluginDataHandlers(pluginName);
            pluginSetup = new EzySimplePluginSetup(dataHandlers, this);
            this.pluginSetups.put(pluginName, pluginSetup);
        }
        return pluginSetup;
    }
}

