/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.socket;

import com.tvd12.ezyfox.callback.EzyCallback;
import com.tvd12.ezyfox.codec.EzyByteToObjectDecoder;
import com.tvd12.ezyfox.codec.EzyMessage;
import com.tvd12.ezyfoxserver.client.socket.EzySocketDataDecoder;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;

public class EzySimpleSocketDataDecoder
implements EzySocketDataDecoder {
    private final Queue<EzyMessage> queue = new LinkedList<EzyMessage>();
    private final EzyByteToObjectDecoder decoder;
    protected ByteBuffer buffer;
    protected volatile boolean active = true;

    public EzySimpleSocketDataDecoder(Object decoder) {
        this.decoder = (EzyByteToObjectDecoder)decoder;
    }

    @Override
    public Object decode(EzyMessage message, byte[] encryptionKey) throws Exception {
        return this.decoder.decode(message, encryptionKey);
    }

    @Override
    public void decode(byte[] bytes, EzyCallback<EzyMessage> callback) throws Exception {
        this.preDecode(bytes);
        this.decoder.decode(this.buffer, this.queue);
        this.handleQueue(callback);
        this.postDecode();
    }

    private void handleQueue(EzyCallback<EzyMessage> callback) throws Exception {
        while (!this.queue.isEmpty() && this.active) {
            do {
                callback.call((Object)this.queue.poll());
            } while (!this.queue.isEmpty());
            if (!this.buffer.hasRemaining()) continue;
            this.decoder.decode(this.buffer, this.queue);
        }
    }

    private void preDecode(byte[] bytes) {
        this.buffer = this.buffer == null ? this.newBuffer(bytes) : this.mergeBytes(bytes);
    }

    private void postDecode() {
        this.buffer = this.getRemainBytes(this.buffer);
    }

    private ByteBuffer newBuffer(byte[] bytes) {
        return ByteBuffer.wrap(bytes);
    }

    private ByteBuffer mergeBytes(byte[] bytes) {
        int capacity = this.buffer.remaining() + bytes.length;
        ByteBuffer merge = ByteBuffer.allocate(capacity).put(this.buffer).put(bytes);
        merge.flip();
        return merge;
    }

    private ByteBuffer getRemainBytes(ByteBuffer old) {
        if (!old.hasRemaining()) {
            return null;
        }
        byte[] bytes = new byte[old.remaining()];
        old.get(bytes);
        return ByteBuffer.wrap(bytes);
    }
}

