/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.socket;

import com.tvd12.ezyfox.util.EzyLoggable;
import java.nio.channels.AsynchronousCloseException;

public abstract class EzySocketAdapter
extends EzyLoggable {
    protected final Object adapterLock = new Object();
    protected volatile boolean active = false;
    protected volatile boolean stopped = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.adapterLock;
        synchronized (object) {
            if (this.active) {
                return;
            }
            this.active = true;
            this.stopped = false;
            Thread newThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    EzySocketAdapter.this.loop();
                }
            });
            newThread.setName(this.getThreadName());
            newThread.start();
        }
    }

    protected abstract String getThreadName();

    protected void loop() {
        this.update();
        this.setStopped(true);
    }

    protected abstract void update();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.adapterLock;
        synchronized (object) {
            this.clear();
            this.active = false;
        }
    }

    protected void clear() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.adapterLock;
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setActive(boolean active) {
        Object object = this.adapterLock;
        synchronized (object) {
            this.active = active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopped() {
        Object object = this.adapterLock;
        synchronized (object) {
            return this.stopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStopped(boolean stopped) {
        Object object = this.adapterLock;
        synchronized (object) {
            this.stopped = stopped;
        }
    }

    protected void handleSocketReaderException(Exception e) {
        if (e instanceof AsynchronousCloseException) {
            this.logger.debug("Socket closed by another thread", (Throwable)e);
        } else {
            this.logger.warn("I/O error at socket-reader", (Throwable)e);
        }
    }
}

