/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.entity;

import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.entity.EzyData;
import com.tvd12.ezyfox.entity.EzyEntity;
import com.tvd12.ezyfox.factory.EzyEntityFactory;
import com.tvd12.ezyfox.util.EzyEquals;
import com.tvd12.ezyfoxserver.client.EzyClient;
import com.tvd12.ezyfoxserver.client.constant.EzyCommand;
import com.tvd12.ezyfoxserver.client.entity.EzyApp;
import com.tvd12.ezyfoxserver.client.entity.EzyZone;
import com.tvd12.ezyfoxserver.client.handler.EzyAppDataHandler;
import com.tvd12.ezyfoxserver.client.handler.EzyAppDataHandlers;
import com.tvd12.ezyfoxserver.client.request.EzyRequest;

public class EzySimpleApp
extends EzyEntity
implements EzyApp {
    protected final int id;
    protected final String name;
    protected final EzyZone zone;
    protected final EzyClient client;
    protected final EzyAppDataHandlers dataHandlers;

    public EzySimpleApp(EzyZone zone, int id, String name) {
        this.client = zone.getClient();
        this.zone = zone;
        this.id = id;
        this.name = name;
        this.dataHandlers = this.client.getHandlerManager().getAppDataHandlers(name);
    }

    @Override
    public void send(EzyRequest request) {
        String cmd = (String)request.getCommand();
        EzyData data = request.serialize();
        this.send(cmd, data);
    }

    @Override
    public void send(String cmd) {
        this.send(cmd, (EzyData)EzyEntityFactory.EMPTY_OBJECT);
    }

    @Override
    public void send(String cmd, EzyData data) {
        this.send(cmd, data, false);
    }

    @Override
    public void send(String cmd, EzyData data, boolean encrypted) {
        EzyArray commandData = EzyEntityFactory.newArray();
        commandData.add(new Object[]{cmd, data});
        this.send(commandData, encrypted);
    }

    @Override
    public void send(EzyArray request) {
        this.send(request, false);
    }

    @Override
    public void send(EzyArray request, boolean encrypted) {
        EzyArray requestData = EzyEntityFactory.newArray();
        requestData.add(new Object[]{this.id, request});
        this.client.send(EzyCommand.APP_REQUEST, requestData, encrypted);
    }

    @Override
    public void udpSend(EzyRequest request) {
        String cmd = (String)request.getCommand();
        EzyData data = request.serialize();
        this.udpSend(cmd, data);
    }

    @Override
    public void udpSend(String cmd) {
        this.udpSend(cmd, (EzyData)EzyEntityFactory.EMPTY_OBJECT);
    }

    @Override
    public void udpSend(String cmd, EzyData data) {
        EzyArray commandData = EzyEntityFactory.newArray();
        commandData.add(new Object[]{cmd, data});
        EzyArray requestData = EzyEntityFactory.newArray();
        requestData.add(new Object[]{this.id, commandData});
        this.client.udpSend(EzyCommand.APP_REQUEST, requestData);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public EzyClient getClient() {
        return this.client;
    }

    @Override
    public EzyZone getZone() {
        return this.zone;
    }

    @Override
    public EzyAppDataHandler<?> getDataHandler(Object cmd) {
        return this.dataHandlers.getHandler(cmd);
    }

    public boolean equals(Object obj) {
        return new EzyEquals().function(t -> t.id).isEquals((Object)this, obj);
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "App(id: " + this.id + ", name: " + this.name + ")";
    }
}

