/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.handler;

import com.tvd12.ezyfoxserver.client.config.EzyClientConfig;
import com.tvd12.ezyfoxserver.client.config.EzyReconnectConfig;
import com.tvd12.ezyfoxserver.client.constant.EzyConnectionStatus;
import com.tvd12.ezyfoxserver.client.event.EzyConnectionFailureEvent;
import com.tvd12.ezyfoxserver.client.handler.EzyAbstractEventHandler;

public class EzyConnectionFailureHandler
extends EzyAbstractEventHandler<EzyConnectionFailureEvent> {
    @Override
    public final void handle(EzyConnectionFailureEvent event) {
        this.logger.info("connection failure, reason: {}", (Object)event.getReason());
        EzyClientConfig config = this.client.getConfig();
        EzyReconnectConfig reconnectConfig = config.getReconnect();
        boolean shouldReconnect = this.shouldReconnect(event);
        boolean mustReconnect = reconnectConfig.isEnable() && shouldReconnect;
        boolean reconnecting = false;
        this.client.setStatus(EzyConnectionStatus.FAILURE);
        if (mustReconnect) {
            reconnecting = this.client.reconnect();
        }
        if (reconnecting) {
            this.onReconnecting(event);
        } else {
            this.onConnectionFailed(event);
        }
        this.postHandle(event);
    }

    protected boolean shouldReconnect(EzyConnectionFailureEvent event) {
        return true;
    }

    protected void onReconnecting(EzyConnectionFailureEvent event) {
    }

    protected void onConnectionFailed(EzyConnectionFailureEvent event) {
    }

    protected void postHandle(EzyConnectionFailureEvent event) {
    }
}

