/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.handler;

import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.security.EzyAsyCrypt;
import com.tvd12.ezyfoxserver.client.handler.EzyAbstractDataHandler;
import com.tvd12.ezyfoxserver.client.request.EzyRequest;
import com.tvd12.ezyfoxserver.client.socket.EzyPingSchedule;
import com.tvd12.ezyfoxserver.client.socket.EzyPingScheduleAware;
import java.util.Arrays;

public abstract class EzyHandshakeHandler
extends EzyAbstractDataHandler
implements EzyPingScheduleAware {
    protected EzyPingSchedule pingSchedule;

    @Override
    public void handle(EzyArray data) {
        this.preHandle(data);
        this.pingSchedule.start();
        this.handleLogin(data);
        this.postHandle(data);
    }

    protected void preHandle(EzyArray data) {
        this.client.setSessionToken((String)data.get(1, String.class));
        this.client.setSessionId((Long)data.get(2, Long.TYPE));
        if (this.client.isEnableEncryption()) {
            this.client.setSessionKey(this.decryptSessionKey((byte[])data.get(3, byte[].class, null)));
        }
    }

    protected byte[] decryptSessionKey(byte[] sessionKey) {
        if (sessionKey == null) {
            if (this.client.isEnableDebug()) {
                return null;
            }
            this.client.close();
            throw new IllegalStateException("maybe server was not enable SSL, you must enable SSL on server or disable SSL on your client or enable debug mode");
        }
        try {
            return EzyAsyCrypt.builder().privateKey(this.client.getPrivateKey()).build().decrypt(sessionKey);
        }
        catch (Throwable e) {
            throw new IllegalStateException("can not decrypt session key: " + Arrays.toString(sessionKey), e);
        }
    }

    protected void postHandle(EzyArray data) {
    }

    protected void handleLogin(EzyArray data) {
        EzyRequest loginRequest = this.getLoginRequest();
        this.client.send(loginRequest, this.client.isEnableEncryption());
    }

    protected abstract EzyRequest getLoginRequest();

    @Override
    public void setPingSchedule(EzyPingSchedule pingSchedule) {
        this.pingSchedule = pingSchedule;
    }
}

