/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.manager;

import com.tvd12.ezyfoxserver.client.entity.EzyApp;
import com.tvd12.ezyfoxserver.client.manager.EzyAppManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EzySimpleAppManager
implements EzyAppManager {
    protected final String zoneName;
    protected final List<EzyApp> appList;
    protected final Map<Integer, EzyApp> appsById;
    protected final Map<String, EzyApp> appsByName;

    public EzySimpleAppManager(String zoneName) {
        this.zoneName = zoneName;
        this.appList = new ArrayList<EzyApp>();
        this.appsById = new HashMap<Integer, EzyApp>();
        this.appsByName = new HashMap<String, EzyApp>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addApp(EzyApp app) {
        EzySimpleAppManager ezySimpleAppManager = this;
        synchronized (ezySimpleAppManager) {
            this.appList.add(app);
            this.appsById.put(app.getId(), app);
            this.appsByName.put(app.getName(), app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EzyApp removeApp(int appId) {
        EzySimpleAppManager ezySimpleAppManager = this;
        synchronized (ezySimpleAppManager) {
            EzyApp app = this.appsById.remove(appId);
            if (app != null) {
                this.appList.remove(app);
                this.appsByName.remove(app.getName());
            }
            return app;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EzyApp getApp() {
        EzySimpleAppManager ezySimpleAppManager = this;
        synchronized (ezySimpleAppManager) {
            return this.appList.isEmpty() ? null : this.appList.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EzyApp> getAppList() {
        ArrayList<EzyApp> list = new ArrayList<EzyApp>(this.appList.size());
        EzySimpleAppManager ezySimpleAppManager = this;
        synchronized (ezySimpleAppManager) {
            list.addAll(this.appList);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EzyApp getAppById(int appId) {
        List<EzyApp> list = this.appList;
        synchronized (list) {
            EzyApp app = this.appsById.get(appId);
            return app;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EzyApp getAppByName(String appName) {
        EzySimpleAppManager ezySimpleAppManager = this;
        synchronized (ezySimpleAppManager) {
            EzyApp app = this.appsByName.get(appName);
            return app;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        EzySimpleAppManager ezySimpleAppManager = this;
        synchronized (ezySimpleAppManager) {
            this.appList.clear();
            this.appsById.clear();
            this.appsByName.clear();
        }
    }
}

