/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.socket;

import com.tvd12.ezyfox.concurrent.EzyEventLoopEvent;
import com.tvd12.ezyfox.concurrent.EzyEventLoopGroup;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.nio.channels.AsynchronousCloseException;

public abstract class EzySocketAdapter
extends EzyLoggable
implements EzyEventLoopEvent {
    protected volatile boolean active = false;
    protected volatile boolean stopped = false;
    protected final Object adapterLock = new Object();
    protected EzyEventLoopGroup eventLoopGroup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.adapterLock;
        synchronized (object) {
            if (this.active) {
                return;
            }
            this.active = true;
            this.stopped = false;
            if (this.eventLoopGroup != null) {
                this.eventLoopGroup.addEvent((EzyEventLoopEvent)this);
            } else {
                Thread newThread = new Thread(this::loop);
                newThread.setName(this.getThreadName());
                newThread.start();
            }
        }
    }

    public boolean call() {
        return false;
    }

    public void onFinished() {
        this.setStopped();
    }

    protected abstract String getThreadName();

    protected void loop() {
        this.update();
        this.setStopped();
    }

    protected abstract void update();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.adapterLock;
        synchronized (object) {
            this.clear();
            this.active = false;
            if (this.eventLoopGroup != null) {
                this.eventLoopGroup.removeEvent((EzyEventLoopEvent)this);
            }
        }
    }

    protected void clear() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.adapterLock;
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopped() {
        Object object = this.adapterLock;
        synchronized (object) {
            return this.stopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStopped() {
        Object object = this.adapterLock;
        synchronized (object) {
            this.stopped = true;
        }
    }

    protected void handleSocketReaderException(Throwable e) {
        if (e instanceof AsynchronousCloseException) {
            this.logger.debug("Socket closed by another thread", e);
        } else {
            this.logger.info("I/O error at socket-reader", e);
        }
    }

    public void setEventLoopGroup(EzyEventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
    }
}

