/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.socket;

import com.tvd12.ezyfoxserver.client.config.EzySocketClientConfig;
import com.tvd12.ezyfoxserver.client.socket.EzySocketClient;
import com.tvd12.ezyfoxserver.client.socket.EzyTcpSocketReader;
import com.tvd12.ezyfoxserver.client.socket.EzyTcpSocketWriter;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;

public class EzyTcpSocketClient
extends EzySocketClient {
    protected SocketChannel socket;

    public EzyTcpSocketClient(EzySocketClientConfig config) {
        super(config);
    }

    @Override
    protected boolean connectNow() {
        try {
            InetSocketAddress socketAddress = new InetSocketAddress(this.host, this.port);
            this.socket = SocketChannel.open();
            this.socket.connect(socketAddress);
            this.socket.configureBlocking(this.eventLoopGroup == null);
            return true;
        }
        catch (Throwable e) {
            this.processConnectionException(e);
            return false;
        }
    }

    @Override
    protected void createAdapters() {
        this.socketReader = new EzyTcpSocketReader();
        this.socketWriter = new EzyTcpSocketWriter();
    }

    @Override
    protected void startAdapters() {
        ((EzyTcpSocketReader)this.socketReader).setSocket(this.socket);
        this.socketReader.start();
        ((EzyTcpSocketWriter)this.socketWriter).setSocket(this.socket);
        this.socketWriter.start();
    }

    @Override
    protected void resetSocket() {
        this.socket = null;
    }

    @Override
    protected void closeSocket() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Throwable e) {
            this.logger.info("close socket error", e);
        }
    }
}

