/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.socket;

import com.tvd12.ezyfox.concurrent.EzyEventLoopGroup;
import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.client.codec.EzyCodecFactory;
import com.tvd12.ezyfoxserver.client.constant.EzyConnectionType;
import com.tvd12.ezyfoxserver.client.constant.EzyDisconnectReason;
import com.tvd12.ezyfoxserver.client.constant.EzySocketStatus;
import com.tvd12.ezyfoxserver.client.constant.EzySocketStatuses;
import com.tvd12.ezyfoxserver.client.constant.EzyTransportType;
import com.tvd12.ezyfoxserver.client.socket.EzyBlockingPacketQueue;
import com.tvd12.ezyfoxserver.client.socket.EzyISocketClient;
import com.tvd12.ezyfoxserver.client.socket.EzyPacketQueue;
import com.tvd12.ezyfoxserver.client.socket.EzyResponseApi;
import com.tvd12.ezyfoxserver.client.socket.EzySimplePackage;
import com.tvd12.ezyfoxserver.client.socket.EzySimpleSocketDataDecoder;
import com.tvd12.ezyfoxserver.client.socket.EzySimpleSocketDataEncoder;
import com.tvd12.ezyfoxserver.client.socket.EzySocketAdapter;
import com.tvd12.ezyfoxserver.client.socket.EzySocketResponseApi;
import com.tvd12.ezyfoxserver.client.socket.EzyUdpSocketReader;
import com.tvd12.ezyfoxserver.client.socket.EzyUdpSocketWriter;
import com.tvd12.ezyfoxserver.client.util.EzyValueStack;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.List;

public class EzyUdpSocketClient
extends EzyLoggable
implements EzyISocketClient {
    protected long sessionId;
    protected String sessionToken;
    protected byte[] sessionKey;
    protected EzyEventLoopGroup eventLoopGroup;
    protected InetSocketAddress serverAddress;
    protected DatagramChannel datagramChannel;
    protected EzyUdpSocketReader socketReader;
    protected EzyUdpSocketWriter socketWriter;
    protected final EzyPacketQueue packetQueue;
    protected final EzyResponseApi responseApi;
    protected final EzyCodecFactory codecFactory;
    protected final EzyValueStack<EzySocketStatus> socketStatuses;

    public EzyUdpSocketClient(EzyCodecFactory codecFactory) {
        this.codecFactory = codecFactory;
        this.packetQueue = new EzyBlockingPacketQueue();
        this.responseApi = this.newResponseApi();
        this.socketStatuses = new EzyValueStack<EzySocketStatus>(EzySocketStatus.NOT_CONNECT);
    }

    private EzyResponseApi newResponseApi() {
        Object encoder = this.codecFactory.newEncoder(EzyConnectionType.SOCKET);
        EzySimpleSocketDataEncoder socketDataEncoder = new EzySimpleSocketDataEncoder(encoder);
        return new EzySocketResponseApi(socketDataEncoder, this.packetQueue);
    }

    @Override
    public void connectTo(String host, int port) {
        EzySocketStatus status = this.socketStatuses.last();
        if (!EzySocketStatuses.isSocketConnectable(status)) {
            this.logger.info("udp socket is connecting...");
            return;
        }
        this.serverAddress = new InetSocketAddress(host, port);
        this.connect0();
    }

    @Override
    public boolean reconnect() {
        EzySocketStatus status = this.socketStatuses.last();
        if (status != EzySocketStatus.CONNECT_FAILED) {
            return false;
        }
        this.logger.info("udp socket is re-connecting...");
        this.connect0();
        return true;
    }

    public void setStatus(EzySocketStatus status) {
        this.socketStatuses.push(status);
    }

    protected void connect0() {
        while (true) {
            try {
                this.connect1();
            }
            catch (BindException e) {
                this.logger.warn("fail to open udp port, re-try again");
                continue;
            }
            break;
        }
    }

    protected void connect1() throws BindException {
        try {
            this.clearAdapters();
            this.createAdapters();
            this.updateAdapters();
            this.closeSocket();
            this.packetQueue.clear();
            this.socketStatuses.clear();
            this.datagramChannel = DatagramChannel.open();
            this.datagramChannel.configureBlocking(this.eventLoopGroup == null);
            this.datagramChannel.bind(null);
            this.datagramChannel.connect(this.serverAddress);
            this.startAdapters();
            this.socketStatuses.push(EzySocketStatus.CONNECTING);
            this.sendHandshakeRequest();
            if (this.eventLoopGroup != null) {
                this.eventLoopGroup.addOneTimeEvent(this::reconnectIfNeed, (long)this.sleepTimeBeforeReconnect());
            } else {
                Thread newThread = new Thread(() -> {
                    try {
                        Thread.sleep(this.sleepTimeBeforeReconnect());
                        this.reconnectIfNeed();
                    }
                    catch (InterruptedException e) {
                        this.logger.error("udp reconnect interrupted", (Throwable)e);
                    }
                });
                newThread.setName("udp-reconnect");
                newThread.start();
            }
        }
        catch (BindException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IllegalStateException("udp can't connect to: " + this.serverAddress, e);
        }
    }

    private void reconnectIfNeed() {
        EzySocketStatus status = this.socketStatuses.last();
        if (status == EzySocketStatus.CONNECTING) {
            this.socketStatuses.push(EzySocketStatus.CONNECT_FAILED);
        }
        this.reconnect();
    }

    protected int sleepTimeBeforeReconnect() {
        return 3000;
    }

    @Override
    public void disconnect(int reason) {
        this.packetQueue.clear();
        this.packetQueue.wakeup();
        this.closeSocket();
        this.clearAdapters();
        this.socketStatuses.push(EzySocketStatus.DISCONNECTED);
    }

    @Override
    public void close() {
        this.disconnect(EzyDisconnectReason.CLOSE.getId());
    }

    @Override
    public void sendMessage(EzyArray message, boolean encrypted) {
        EzySimplePackage pack = new EzySimplePackage(message, encrypted, this.sessionKey, EzyTransportType.UDP);
        try {
            this.responseApi.response(pack);
        }
        catch (Throwable e) {
            this.logger.info("udp send message: " + message + " error", e);
        }
    }

    public void popReadMessages(List<EzyArray> buffer) {
        EzySocketStatus status = this.socketStatuses.last();
        if (status == EzySocketStatus.CONNECTING || status == EzySocketStatus.CONNECTED) {
            this.socketReader.popMessages(buffer);
        }
    }

    protected void createAdapters() {
        this.socketReader = new EzyUdpSocketReader();
        this.socketWriter = new EzyUdpSocketWriter();
    }

    protected void updateAdapters() {
        Object decoder = this.codecFactory.newDecoder(EzyConnectionType.SOCKET);
        EzySimpleSocketDataDecoder socketDataDecoder = new EzySimpleSocketDataDecoder(decoder);
        this.socketReader.setDecoder(socketDataDecoder);
        this.socketReader.setEventLoopGroup(this.eventLoopGroup);
        this.socketWriter.setPacketQueue(this.packetQueue);
        this.socketWriter.setEventLoopGroup(this.eventLoopGroup);
    }

    protected void startAdapters() {
        this.socketReader.setDecryptionKey(this.sessionKey);
        this.socketReader.setDatagramChannel(this.datagramChannel);
        this.socketReader.start();
        this.socketWriter.setDatagramChannel(this.datagramChannel);
        this.socketWriter.start();
    }

    protected void clearAdapters() {
        this.clearAdapter(this.socketReader);
        this.socketReader = null;
        this.clearAdapter(this.socketWriter);
        this.socketWriter = null;
    }

    protected void clearAdapter(EzySocketAdapter adapter) {
        if (adapter != null) {
            adapter.stop();
        }
    }

    protected void closeSocket() {
        try {
            if (this.datagramChannel != null) {
                this.datagramChannel.close();
            }
        }
        catch (Throwable e) {
            this.logger.info("close udp socket error", e);
        }
    }

    protected void sendHandshakeRequest() throws Exception {
        int tokenSize = this.sessionToken.length();
        int messageSize = 0;
        messageSize += 8;
        messageSize += 2;
        ByteBuffer buffer = ByteBuffer.allocate(3 + (messageSize += tokenSize));
        byte header = 0;
        header = (byte)(header | 0x20);
        buffer.put(header);
        buffer.putShort((short)messageSize);
        buffer.putLong(this.sessionId);
        buffer.putShort((short)tokenSize);
        buffer.put(this.sessionToken.getBytes());
        buffer.flip();
        this.datagramChannel.send(buffer, this.serverAddress);
    }

    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public void setSessionKey(byte[] sessionKey) {
        this.sessionKey = sessionKey;
    }

    public void setEventLoopGroup(EzyEventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
    }
}

