/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.ssl;

import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EzySslTrustManagerFactory
extends TrustManagerFactorySpi {
    private static final TrustManager TRUST_MANAGER = new X509TrustManager(){
        private final Logger logger = LoggerFactory.getLogger(this.getClass());

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            this.logger.debug("ssl: get accepted issuers");
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
            this.logger.debug("ssl: check client trusted, chain = {}, authType = {}", (Object)chain, (Object)authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
            this.logger.debug("ssl: check server trusted, chain = {}, authType = {}", (Object)chain, (Object)authType);
        }
    };
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final EzySslTrustManagerFactory INSTANCE = new EzySslTrustManagerFactory();

    private EzySslTrustManagerFactory() {
    }

    public static EzySslTrustManagerFactory getInstance() {
        return INSTANCE;
    }

    @Override
    protected TrustManager[] engineGetTrustManagers() {
        this.logger.debug("ssl: engine get trust managers");
        return new TrustManager[]{TRUST_MANAGER};
    }

    @Override
    protected void engineInit(KeyStore keystore) {
        this.logger.debug("ssl: engine init, keystore = {}", (Object)keystore);
    }

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) {
        this.logger.debug("ssl: engine init, parameters = {}", (Object)managerFactoryParameters);
    }
}

