/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.socket;

import com.tvd12.ezyfoxserver.client.socket.EzyPacket;
import com.tvd12.ezyfoxserver.client.socket.EzyPacketQueue;
import java.util.LinkedList;
import java.util.Queue;

public class EzyBlockingPacketQueue
implements EzyPacketQueue {
    protected final int capacity;
    protected final Queue<EzyPacket> queue;
    protected volatile boolean empty = true;
    protected volatile boolean processing = false;

    public EzyBlockingPacketQueue() {
        this(10000);
    }

    public EzyBlockingPacketQueue(int capacity) {
        this.capacity = capacity;
        this.queue = new LinkedList<EzyPacket>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        EzyBlockingPacketQueue ezyBlockingPacketQueue = this;
        synchronized (ezyBlockingPacketQueue) {
            return this.queue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        EzyBlockingPacketQueue ezyBlockingPacketQueue = this;
        synchronized (ezyBlockingPacketQueue) {
            this.queue.clear();
            this.empty = true;
            this.processing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EzyPacket take() {
        EzyBlockingPacketQueue ezyBlockingPacketQueue = this;
        synchronized (ezyBlockingPacketQueue) {
            EzyPacket packet = this.queue.poll();
            this.processing = false;
            this.empty = this.queue.isEmpty();
            this.notifyAll();
            return packet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EzyPacket peek() throws InterruptedException {
        EzyBlockingPacketQueue ezyBlockingPacketQueue = this;
        synchronized (ezyBlockingPacketQueue) {
            while (this.empty || this.processing) {
                this.wait();
            }
            this.processing = true;
            return this.queue.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EzyPacket peekNow() {
        EzyBlockingPacketQueue ezyBlockingPacketQueue = this;
        synchronized (ezyBlockingPacketQueue) {
            if (this.empty || this.processing) {
                return null;
            }
            this.processing = true;
            return this.queue.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFull() {
        EzyBlockingPacketQueue ezyBlockingPacketQueue = this;
        synchronized (ezyBlockingPacketQueue) {
            int size = this.queue.size();
            return size >= this.capacity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        EzyBlockingPacketQueue ezyBlockingPacketQueue = this;
        synchronized (ezyBlockingPacketQueue) {
            return this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(EzyPacket packet) {
        EzyBlockingPacketQueue ezyBlockingPacketQueue = this;
        synchronized (ezyBlockingPacketQueue) {
            int size = this.queue.size();
            if (size >= this.capacity) {
                return false;
            }
            this.queue.offer(packet);
            this.empty = false;
            if (!this.processing) {
                this.notifyAll();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void again() {
        EzyBlockingPacketQueue ezyBlockingPacketQueue = this;
        synchronized (ezyBlockingPacketQueue) {
            this.processing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wakeup() {
        EzyBlockingPacketQueue ezyBlockingPacketQueue = this;
        synchronized (ezyBlockingPacketQueue) {
            this.queue.offer(null);
            this.empty = false;
            this.processing = false;
            this.notifyAll();
        }
    }
}

