/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.socket;

import com.tvd12.ezyfox.concurrent.EzyEventLoopEvent;
import com.tvd12.ezyfox.concurrent.EzyEventLoopGroup;
import com.tvd12.ezyfox.concurrent.EzyExecutors;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.client.EzyClient;
import com.tvd12.ezyfoxserver.client.constant.EzyDisconnectReason;
import com.tvd12.ezyfoxserver.client.event.EzyLostPingEvent;
import com.tvd12.ezyfoxserver.client.manager.EzyPingManager;
import com.tvd12.ezyfoxserver.client.request.EzyPingRequest;
import com.tvd12.ezyfoxserver.client.socket.EzySocketEventQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class EzyPingSchedule
extends EzyLoggable
implements EzyEventLoopEvent {
    protected final EzyClient client;
    protected final EzyPingManager pingManager;
    protected final EzyEventLoopGroup eventLoopGroup;
    protected final ScheduledExecutorService scheduledExecutor;
    protected ScheduledFuture<?> scheduledFuture;
    protected EzySocketEventQueue socketEventQueue;

    public EzyPingSchedule(EzyClient client, EzyEventLoopGroup eventLoopGroup) {
        this.client = client;
        this.eventLoopGroup = eventLoopGroup;
        this.pingManager = client.getPingManager();
        this.scheduledExecutor = eventLoopGroup != null ? null : this.newScheduledExecutor();
    }

    protected ScheduledExecutorService newScheduledExecutor() {
        ScheduledExecutorService answer = EzyExecutors.newSingleThreadScheduledExecutor((String)"ping-schedule");
        Runtime.getRuntime().addShutdownHook(new Thread(answer::shutdown));
        return answer;
    }

    public boolean call() {
        this.sendPingRequest();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        EzyPingSchedule ezyPingSchedule = this;
        synchronized (ezyPingSchedule) {
            long periodMillis = this.pingManager.getPingPeriod();
            if (this.eventLoopGroup != null) {
                this.eventLoopGroup.addScheduleEvent((EzyEventLoopEvent)this, periodMillis, periodMillis);
            } else {
                this.scheduledFuture = this.scheduledExecutor.scheduleAtFixedRate(() -> {
                    try {
                        this.sendPingRequest();
                    }
                    catch (Throwable e) {
                        this.logger.info("send ping request failed", e);
                    }
                }, periodMillis, periodMillis, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.eventLoopGroup != null) {
            this.eventLoopGroup.removeEvent((EzyEventLoopEvent)this);
        } else {
            EzyPingSchedule ezyPingSchedule = this;
            synchronized (ezyPingSchedule) {
                if (this.scheduledFuture != null) {
                    this.scheduledFuture.cancel(true);
                }
                this.scheduledFuture = null;
            }
        }
    }

    public void shutdown() {
        this.scheduledExecutor.shutdown();
    }

    private void sendPingRequest() {
        int maxLostPingCount;
        int lostPingCount = this.pingManager.increaseLostPingCount();
        if (lostPingCount >= (maxLostPingCount = this.pingManager.getMaxLostPingCount())) {
            this.client.getSocket().disconnect(EzyDisconnectReason.SERVER_NOT_RESPONDING.getId());
        } else {
            this.client.send(EzyPingRequest.getInstance());
        }
        if (lostPingCount > 1) {
            this.logger.info("lost ping count: " + lostPingCount);
            EzyLostPingEvent event = new EzyLostPingEvent(lostPingCount);
            this.socketEventQueue.addEvent(event);
        }
    }

    public void setSocketEventQueue(EzySocketEventQueue socketEventQueue) {
        this.socketEventQueue = socketEventQueue;
    }
}

