/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.socket;

import com.tvd12.ezyfox.callback.EzyCallback;
import com.tvd12.ezyfox.codec.EzyMessage;
import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfoxserver.client.concurrent.EzySynchronizedQueue;
import com.tvd12.ezyfoxserver.client.socket.EzySocketAdapter;
import com.tvd12.ezyfoxserver.client.socket.EzySocketDataDecoder;
import com.tvd12.ezyfoxserver.client.util.EzyQueue;
import java.nio.ByteBuffer;
import java.util.List;

public abstract class EzySocketReader
extends EzySocketAdapter {
    protected final ByteBuffer buffer;
    protected final EzyQueue<EzyArray> dataQueue = new EzySynchronizedQueue<EzyArray>();
    protected final int readBufferSize;
    protected final EzyCallback<EzyMessage> decodeBytesCallback;
    protected byte[] sessionKey;
    protected EzySocketDataDecoder decoder;

    public EzySocketReader() {
        this.readBufferSize = 8192;
        this.buffer = this.newBuffer(this.readBufferSize);
        this.decodeBytesCallback = this::onMessageReceived;
    }

    protected ByteBuffer newBuffer(int readBufferSize) {
        return ByteBuffer.allocateDirect(readBufferSize);
    }

    @Override
    protected void update() {
        while (true) {
            try {
                while (true) {
                    if (!this.active) {
                        return;
                    }
                    this.buffer.clear();
                    int bytesToRead = this.readSocketData();
                    if (bytesToRead <= 0) {
                        return;
                    }
                    this.buffer.flip();
                    byte[] binary = new byte[this.buffer.limit()];
                    this.buffer.get(binary);
                    this.decoder.decode(binary, this.decodeBytesCallback);
                }
            }
            catch (InterruptedException e) {
                this.logger.debug("socket reader interrupted", (Throwable)e);
                return;
            }
            catch (Throwable e) {
                this.logger.info("I/O error at socket-reader", e);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean call() {
        try {
            if (!this.active) {
                return false;
            }
            this.buffer.clear();
            int bytesToRead = this.readSocketData();
            if (bytesToRead < 0) {
                return false;
            }
            if (bytesToRead > 0) {
                this.buffer.flip();
                byte[] binary = new byte[this.buffer.limit()];
                this.buffer.get(binary);
                this.decoder.decode(binary, this.decodeBytesCallback);
            }
        }
        catch (Throwable e) {
            this.logger.info("I/O error at socket-reader", e);
            return false;
        }
        return true;
    }

    protected abstract int readSocketData();

    @Override
    protected void clear() {
        if (this.dataQueue != null) {
            this.dataQueue.clear();
        }
    }

    public void popMessages(List<EzyArray> buffer) {
        this.dataQueue.pollAll(buffer);
    }

    private void onMessageReceived(EzyMessage message) {
        try {
            Object data = this.decoder.decode(message, this.sessionKey);
            this.dataQueue.add((EzyArray)data);
        }
        catch (Throwable e) {
            this.logger.info("decode error at socket-reader", e);
        }
    }

    public void setSessionKey(byte[] sessionKey) {
        this.sessionKey = sessionKey;
    }

    public void setDecoder(EzySocketDataDecoder decoder) {
        this.decoder = decoder;
    }

    @Override
    protected String getThreadName() {
        return "ezyfox-socket-reader";
    }
}

