/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.client.socket;

import com.tvd12.ezyfoxserver.client.socket.EzyPacket;
import com.tvd12.ezyfoxserver.client.socket.EzyPacketQueue;
import com.tvd12.ezyfoxserver.client.socket.EzySocketAdapter;
import java.nio.ByteBuffer;

public abstract class EzySocketWriter
extends EzySocketAdapter {
    protected EzyPacketQueue packetQueue;
    protected final ByteBuffer writeBuffer = ByteBuffer.allocate(8192);

    @Override
    protected void update() {
        while (true) {
            try {
                while (true) {
                    if (!this.active) {
                        return;
                    }
                    EzyPacket packet = this.packetQueue.peek();
                    if (packet == null) {
                        return;
                    }
                    int writtenBytes = this.writePacketToSocket(packet);
                    if (writtenBytes < 0) {
                        return;
                    }
                    if (packet.isReleased()) {
                        this.packetQueue.take();
                        continue;
                    }
                    this.packetQueue.again();
                }
            }
            catch (InterruptedException e) {
                this.logger.debug("socket-writer thread interrupted", (Throwable)e);
                return;
            }
            catch (Throwable e) {
                this.logger.info("problems in socket-writer main loop, thread", e);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean call() {
        try {
            if (!this.active) {
                return false;
            }
            EzyPacket packet = this.packetQueue.peekNow();
            if (packet == null) {
                return true;
            }
            int writtenBytes = this.writePacketToSocket(packet);
            if (writtenBytes < 0) {
                return false;
            }
            if (packet.isReleased()) {
                this.packetQueue.take();
            } else {
                this.packetQueue.again();
            }
        }
        catch (Throwable e) {
            this.logger.info("problems in socket-writer main loop, thread", e);
            return false;
        }
        return true;
    }

    protected int writePacketToSocket(EzyPacket packet) {
        byte[] bytes = this.getBytesToWrite(packet);
        int bytesToWrite = bytes.length;
        ByteBuffer buffer = this.getWriteBuffer(this.writeBuffer, bytesToWrite);
        buffer.clear();
        buffer.put(bytes);
        buffer.flip();
        int bytesWritten = this.writeToSocket(buffer);
        if (bytesWritten < bytesToWrite) {
            byte[] remainBytes = this.getPacketFragment(buffer);
            packet.setFragment(remainBytes);
        } else {
            packet.release();
        }
        return bytesWritten;
    }

    protected int writeToSocket(ByteBuffer buffer) {
        return 0;
    }

    protected ByteBuffer getWriteBuffer(ByteBuffer fixed, int bytesToWrite) {
        return bytesToWrite > fixed.capacity() ? ByteBuffer.allocate(bytesToWrite) : fixed;
    }

    private byte[] getPacketFragment(ByteBuffer buffer) {
        byte[] remainBytes = new byte[buffer.remaining()];
        buffer.get(remainBytes);
        return remainBytes;
    }

    protected byte[] getBytesToWrite(EzyPacket packet) {
        return (byte[])packet.getData();
    }

    public void setPacketQueue(EzyPacketQueue packetQueue) {
        this.packetQueue = packetQueue;
    }

    @Override
    protected String getThreadName() {
        return "ezyfox-socket-writer";
    }
}

